/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.SonarException;

@Phase(name=Phase.Name.PRE)
@DependedUpon(value={"BEFORE_SQUID"})
public final class JavaSourceImporter
implements Sensor {
    private boolean importSources = false;

    public JavaSourceImporter(Configuration conf) {
        this.importSources = conf.getBoolean("sonar.importSources", true);
    }

    JavaSourceImporter(boolean importSources) {
        this.importSources = importSources;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "java".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        this.analyse(project.getFileSystem(), context);
    }

    void analyse(ProjectFileSystem fileSystem, SensorContext context) {
        this.parseDirs(context, fileSystem.mainFiles(new String[]{"java"}), false, fileSystem.getSourceCharset());
        this.parseDirs(context, fileSystem.testFiles(new String[]{"java"}), true, fileSystem.getSourceCharset());
    }

    void parseDirs(SensorContext context, List<InputFile> inputFiles, boolean unitTest, Charset sourcesEncoding) {
        for (InputFile inputFile : inputFiles) {
            JavaFile javaFile = JavaFile.fromRelativePath((String)inputFile.getRelativePath(), (boolean)unitTest);
            this.importSource(context, javaFile, inputFile, sourcesEncoding);
        }
    }

    void importSource(SensorContext context, JavaFile javaFile, InputFile inputFile, Charset sourcesEncoding) {
        String source = null;
        if (this.importSources) {
            source = this.loadSourceFromFile(inputFile, sourcesEncoding);
        }
        try {
            context.index((Resource)javaFile);
            if (source != null) {
                context.saveSource((Resource)javaFile, source);
            }
        }
        catch (Exception e) {
            throw new SonarException("Unable to read and import the source file : '" + inputFile.getFile().getAbsolutePath() + "' with the charset : '" + sourcesEncoding.name() + "'.", (Throwable)e);
        }
    }

    protected String loadSourceFromFile(InputFile inputFile, Charset sourcesEncoding) {
        try {
            return FileUtils.readFileToString((File)inputFile.getFile(), (String)sourcesEncoding.name());
        }
        catch (Exception e) {
            throw new SonarException("Unable to read and import the source file : '" + inputFile.getFile().getAbsolutePath() + "' with the charset : '" + sourcesEncoding.name() + "'.", (Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

