/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.SonarPlugin;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.java.SonarComponents;
import org.sonar.plugins.java.JavaRuleRepository;
import org.sonar.plugins.java.JavaSonarWayProfile;
import org.sonar.plugins.java.JavaSonarWayWithFindbugsProfile;
import org.sonar.plugins.java.JavaSourceImporter;
import org.sonar.plugins.java.JavaSquidSensor;
import org.sonar.plugins.java.decorators.ChidamberKemererDistributionBuilder;
import org.sonar.plugins.java.decorators.ClassesDecorator;
import org.sonar.plugins.java.decorators.FileComplexityDistributionDecorator;
import org.sonar.plugins.java.decorators.FunctionComplexityDistributionBuilder;
import org.sonar.plugins.java.decorators.FunctionsDecorator;

public class JavaSquidPlugin
extends SonarPlugin {
    private static final String JAVA_CATEGORY = "java";
    private static final String GENERAL_SUBCATEGORY = "General";
    public static final String SQUID_ANALYSE_ACCESSORS_PROPERTY = "sonar.squid.analyse.property.accessors";
    public static final boolean SQUID_ANALYSE_ACCESSORS_DEFAULT_VALUE = true;
    public static final String FIELDS_TO_EXCLUDE_FROM_LCOM4_COMPUTATION = "sonar.squid.fieldsToExcludeFromLcom4Computation";
    public static final String FIELDS_TO_EXCLUDE_FROM_LCOM4_COMPUTATION_DEFAULT_VALUE = "LOG, logger";

    public List getExtensions() {
        return ImmutableList.of((Object)PropertyDefinition.builder((String)SQUID_ANALYSE_ACCESSORS_PROPERTY).defaultValue("true").category(JAVA_CATEGORY).subCategory(GENERAL_SUBCATEGORY).name("Separate accessors").description("Flag whether Squid should separate accessors (getters/setters) from methods. In that case, accessors are not counted in metrics such as complexity or API documentation.").type(PropertyType.BOOLEAN).onQualifiers("TRK", new String[0]).build(), (Object)PropertyDefinition.builder((String)FIELDS_TO_EXCLUDE_FROM_LCOM4_COMPUTATION).defaultValue(FIELDS_TO_EXCLUDE_FROM_LCOM4_COMPUTATION_DEFAULT_VALUE).category(JAVA_CATEGORY).subCategory(GENERAL_SUBCATEGORY).name("List of fields to exclude from LCOM4 computation").description("Some fields should not be taken into account when computing LCOM4 measure as they unexpectedly and artificially decrease the LCOM4 measure. The best example is a logger used by all methods of a class. All field names to exclude from LCOM4 computation must be separated by a comma.").onQualifiers("TRK", new String[0]).build(), (Object)PropertyDefinition.builder((String)"sonar.skipDesign").defaultValue("false").category(JAVA_CATEGORY).subCategory(GENERAL_SUBCATEGORY).name("Skip design analysis").type(PropertyType.BOOLEAN).hidden().build(), JavaSourceImporter.class, JavaRuleRepository.class, JavaSonarWayProfile.class, JavaSonarWayWithFindbugsProfile.class, SonarComponents.class, JavaSquidSensor.class, ChidamberKemererDistributionBuilder.class, ClassesDecorator.class, FileComplexityDistributionDecorator.class, (Object[])new Object[]{FunctionComplexityDistributionBuilder.class, FunctionsDecorator.class});
    }
}

