/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java.decorators;

import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.Scopes;

public class FileComplexityDistributionDecorator
implements Decorator {
    private static final Number[] LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};

    @DependsUpon
    public Metric dependOnComplexity() {
        return CoreMetrics.COMPLEXITY;
    }

    @DependedUpon
    public Metric generatesComplexityDistribution() {
        return CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "java".equals(project.getLanguageKey());
    }

    private static boolean shouldExecuteOn(Resource resource, DecoratorContext context) {
        return Scopes.isFile((Resource)resource) && context.getMeasure(CoreMetrics.COMPLEXITY) != null;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (FileComplexityDistributionDecorator.shouldExecuteOn(resource, context)) {
            RangeDistributionBuilder builder = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, LIMITS);
            Measure complexity = context.getMeasure(CoreMetrics.COMPLEXITY);
            builder.add((Number)complexity.getValue());
            Measure measure = builder.build(true);
            measure.setPersistenceMode(PersistenceMode.MEMORY);
            context.saveMeasure(measure);
        }
    }
}

