/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.squid.measures.MetricDef;

public class ComplexityVisitor
extends JavaAstVisitor {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.METHOD_BODY, JavaGrammar.IF_STATEMENT, JavaGrammar.FOR_STATEMENT, JavaGrammar.WHILE_STATEMENT, JavaGrammar.DO_STATEMENT, JavaKeyword.CASE, JavaGrammar.RETURN_STATEMENT, JavaGrammar.THROW_STATEMENT, JavaGrammar.CATCH_CLAUSE, JavaGrammar.CONDITIONAL_EXPRESSION, JavaPunctuator.ANDAND, JavaPunctuator.OROR});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(JavaGrammar.RETURN_STATEMENT) && this.isLastReturnStatement(astNode)) {
            return;
        }
        this.getContext().peekSourceCode().add((MetricDef)JavaMetric.COMPLEXITY, 1.0);
    }

    private boolean isLastReturnStatement(AstNode astNode) {
        AstNode parent = astNode.getParent().getParent().getParent();
        AstNode block = astNode.getFirstAncestor(JavaGrammar.BLOCK_STATEMENTS);
        return block.getParent().getParent().is(JavaGrammar.METHOD_BODY) && parent == block;
    }
}

