/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;

public class SuppressWarningsAnnotationUtils {
    private static final String SUPPRESS_WARNINGS_ANNOTATION_NAME = "SuppressWarnings";
    private static final String SUPPRESS_WARNINGS_ANNOTATION_FQ_NAME = "java.lang.SuppressWarnings";
    private static final String VALUE = "\"all\"";

    private SuppressWarningsAnnotationUtils() {
    }

    public static boolean isSuppressAllWarnings(AstNode astNode) {
        AstNode node;
        if (astNode.is(JavaGrammar.CLASS_DECLARATION, JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION)) {
            for (AstNode modifierNode = astNode.getPreviousAstNode(); modifierNode != null && modifierNode.is(JavaGrammar.MODIFIER); modifierNode = modifierNode.getPreviousAstNode()) {
                if (!SuppressWarningsAnnotationUtils.isAnnotationSupressAllWarnings(modifierNode)) continue;
                return true;
            }
            return false;
        }
        if (astNode.is(JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST)) {
            node = astNode.getFirstAncestor(JavaGrammar.CLASS_BODY_DECLARATION);
        } else if (astNode.is(JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST)) {
            node = astNode.getFirstAncestor(JavaGrammar.INTERFACE_BODY_DECLARATION);
        } else if (astNode.is(JavaGrammar.ANNOTATION_METHOD_REST)) {
            node = astNode.getFirstAncestor(JavaGrammar.ANNOTATION_TYPE_ELEMENT_DECLARATION);
        } else {
            throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType());
        }
        for (AstNode modifierNode : node.getChildren(JavaGrammar.MODIFIER)) {
            if (!SuppressWarningsAnnotationUtils.isAnnotationSupressAllWarnings(modifierNode)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationSupressAllWarnings(AstNode modifierNode) {
        String name;
        AstNode annotationNode = modifierNode.getFirstChild();
        if (annotationNode.is(JavaGrammar.ANNOTATION) && (SUPPRESS_WARNINGS_ANNOTATION_NAME.equals(name = SuppressWarningsAnnotationUtils.getAnnotationName(annotationNode)) || SUPPRESS_WARNINGS_ANNOTATION_FQ_NAME.equals(name))) {
            for (AstNode valueNode : annotationNode.getDescendants(JavaTokenType.LITERAL)) {
                if (!VALUE.equals(valueNode.getTokenValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static String getAnnotationName(AstNode astNode) {
        StringBuilder sb = new StringBuilder();
        for (Token token : astNode.getFirstChild(JavaGrammar.QUALIFIED_IDENTIFIER).getTokens()) {
            sb.append(token.getValue());
        }
        return sb.toString();
    }
}

