/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.impl.ast.AstXmlPrinter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.model.JavaTree;
import org.sonar.java.model.KindMaps;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.VariableTree;

public class JavaTreeMaker {
    private final KindMaps kindMaps = new KindMaps();

    private static void checkType(AstNode astNode, AstNodeType ... expected) {
        Preconditions.checkArgument(astNode.is(expected), "Unexpected AstNodeType: %s", astNode.getType().toString());
    }

    private IdentifierTree identifier(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaTokenType.IDENTIFIER, JavaKeyword.THIS, JavaKeyword.CLASS, JavaKeyword.SUPER);
        return new JavaTree.IdentifierTreeImpl(astNode, astNode.getTokenValue());
    }

    private ExpressionTree qualifiedIdentifier(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.QUALIFIED_IDENTIFIER);
        List<AstNode> identifierNodes = astNode.getChildren(JavaTokenType.IDENTIFIER);
        Object result = this.identifier(identifierNodes.get(0));
        for (int i = 1; i < identifierNodes.size(); ++i) {
            result = new JavaTree.MemberSelectExpressionTreeImpl(identifierNodes.get(i), (ExpressionTree)result, this.identifier(identifierNodes.get(i)));
        }
        return result;
    }

    private List<ExpressionTree> qualifiedIdentifierList(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.QUALIFIED_IDENTIFIER_LIST);
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode qualifiedIdentifierNode : astNode.getChildren(JavaGrammar.QUALIFIED_IDENTIFIER)) {
            result.add(this.qualifiedIdentifier(qualifiedIdentifierNode));
        }
        return result.build();
    }

    @VisibleForTesting
    LiteralTree literal(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.LITERAL);
        AstNode childNode = astNode.getFirstChild();
        return new JavaTree.LiteralTreeImpl(childNode, this.kindMaps.getLiteral(childNode.getType()));
    }

    @VisibleForTesting
    PrimitiveTypeTree basicType(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.BASIC_TYPE, JavaKeyword.VOID);
        return new JavaTree.PrimitiveTypeTreeImpl(astNode);
    }

    private ExpressionTree classType(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.CLASS_TYPE, JavaGrammar.CREATED_NAME);
        AstNode child = astNode.getFirstChild();
        Object result = this.identifier(child);
        for (int i = 1; i < astNode.getNumberOfChildren(); ++i) {
            child = astNode.getChild(i);
            if (child.is(JavaTokenType.IDENTIFIER)) {
                result = new JavaTree.MemberSelectExpressionTreeImpl(child, (ExpressionTree)result, this.identifier(child));
                continue;
            }
            if (child.is(JavaGrammar.TYPE_ARGUMENTS)) {
                result = new JavaTree.ParameterizedTypeTreeImpl(child, (ExpressionTree)result, this.typeArguments(child));
                continue;
            }
            if (child.is(JavaGrammar.NON_WILDCARD_TYPE_ARGUMENTS)) {
                result = new JavaTree.ParameterizedTypeTreeImpl(child, (ExpressionTree)result, this.nonWildcardTypeArguments(child));
                continue;
            }
            if (child.is(JavaPunctuator.DOT)) continue;
            throw new IllegalStateException("Unexpected AstNodeType: " + astNode.getType().toString());
        }
        return result;
    }

    @VisibleForTesting
    List<Tree> typeArguments(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.TYPE_ARGUMENTS);
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode child : astNode.getChildren(JavaGrammar.TYPE_ARGUMENT)) {
            Object typeArgument;
            AstNode referenceTypeNode = child.getFirstChild(JavaGrammar.REFERENCE_TYPE);
            ExpressionTree expressionTree = typeArgument = referenceTypeNode != null ? this.referenceType(referenceTypeNode) : null;
            if (child.getFirstChild().is(JavaPunctuator.QUERY)) {
                Tree.Kind kind = child.hasDirectChildren(JavaKeyword.EXTENDS) ? Tree.Kind.EXTENDS_WILDCARD : (child.hasDirectChildren(JavaKeyword.SUPER) ? Tree.Kind.SUPER_WILDCARD : Tree.Kind.UNBOUNDED_WILDCARD);
                typeArgument = new JavaTree.WildcardTreeImpl(child, kind, (Tree)typeArgument);
            }
            result.add(typeArgument);
        }
        return result.build();
    }

    private List<Tree> nonWildcardTypeArguments(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.NON_WILDCARD_TYPE_ARGUMENTS);
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode child : astNode.getChildren(JavaGrammar.REFERENCE_TYPE)) {
            result.add(this.referenceType(child));
        }
        return result.build();
    }

    @VisibleForTesting
    ExpressionTree referenceType(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.REFERENCE_TYPE, JavaGrammar.TYPE);
        PrimitiveTypeTree result = astNode.getFirstChild().is(JavaGrammar.BASIC_TYPE) ? this.basicType(astNode.getFirstChild()) : this.classType(astNode.getFirstChild());
        return this.applyDim((ExpressionTree)result, astNode.getChildren(JavaGrammar.DIM).size());
    }

    private ModifiersTree modifiers(List<AstNode> modifierNodes) {
        if (modifierNodes.isEmpty()) {
            return JavaTree.ModifiersTreeImpl.EMPTY;
        }
        ImmutableList.Builder modifiers = ImmutableList.builder();
        for (AstNode astNode : modifierNodes) {
            Preconditions.checkArgument(astNode.is(JavaGrammar.MODIFIER), "Unexpected AstNodeType: %s", astNode.getType().toString());
            astNode = astNode.getFirstChild();
            if (astNode.is(JavaGrammar.ANNOTATION)) continue;
            JavaKeyword keyword = (JavaKeyword)astNode.getType();
            modifiers.add(this.kindMaps.getModifier(keyword));
        }
        return new JavaTree.ModifiersTreeImpl(modifierNodes.get(0), (List<Modifier>)((Object)modifiers.build()));
    }

    private VariableTree variableDeclarator(ModifiersTree modifiers, ExpressionTree type, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.VARIABLE_DECLARATOR);
        return new JavaTree.VariableTreeImpl(astNode, modifiers, (Tree)this.applyDim(type, astNode.getChildren(JavaGrammar.DIM).size()), astNode.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue(), astNode.hasDirectChildren(JavaGrammar.VARIABLE_INITIALIZER) ? this.variableInitializer(astNode.getFirstChild(JavaGrammar.VARIABLE_INITIALIZER)) : null);
    }

    private List<StatementTree> variableDeclarators(ModifiersTree modifiers, ExpressionTree type, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.VARIABLE_DECLARATORS);
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode variableDeclaratorNode : astNode.getChildren(JavaGrammar.VARIABLE_DECLARATOR)) {
            result.add(this.variableDeclarator(modifiers, type, variableDeclaratorNode));
        }
        return result.build();
    }

    public CompilationUnitTree compilationUnit(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.COMPILATION_UNIT);
        ImmutableList.Builder imports = ImmutableList.builder();
        for (AstNode importNode : astNode.getChildren(JavaGrammar.IMPORT_DECLARATION)) {
            imports.add(new JavaTree.ImportTreeImpl(importNode, importNode.hasDirectChildren(JavaKeyword.STATIC), (Tree)this.qualifiedIdentifier(importNode.getFirstChild(JavaGrammar.QUALIFIED_IDENTIFIER))));
        }
        ImmutableList.Builder types = ImmutableList.builder();
        for (AstNode typeNode : astNode.getChildren(JavaGrammar.TYPE_DECLARATION)) {
            AstNode declarationNode = typeNode.getFirstChild(JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION);
            if (declarationNode == null) continue;
            types.add(this.typeDeclaration(this.modifiers(typeNode.getChildren(JavaGrammar.MODIFIER)), declarationNode));
        }
        ExpressionTree packageDeclaration = null;
        if (astNode.hasDirectChildren(JavaGrammar.PACKAGE_DECLARATION)) {
            packageDeclaration = this.qualifiedIdentifier(astNode.getFirstChild(JavaGrammar.PACKAGE_DECLARATION).getFirstChild(JavaGrammar.QUALIFIED_IDENTIFIER));
        }
        return new JavaTree.CompilationUnitTreeImpl(astNode, packageDeclaration, (List<ImportTree>)((Object)imports.build()), (List<Tree>)((Object)types.build()));
    }

    private ClassTree typeDeclaration(ModifiersTree modifiers, AstNode astNode) {
        if (astNode.is(JavaGrammar.CLASS_DECLARATION)) {
            return this.classDeclaration(modifiers, astNode);
        }
        if (astNode.is(JavaGrammar.ENUM_DECLARATION)) {
            return this.enumDeclaration(modifiers, astNode);
        }
        if (astNode.is(JavaGrammar.INTERFACE_DECLARATION)) {
            return this.interfaceDeclaration(modifiers, astNode);
        }
        if (astNode.is(JavaGrammar.ANNOTATION_TYPE_DECLARATION)) {
            return this.annotationTypeDeclaration(modifiers, astNode);
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType().toString());
    }

    private ClassTree classDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.CLASS_DECLARATION);
        String simpleName = astNode.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue();
        AstNode extendsNode = astNode.getFirstChild(JavaKeyword.EXTENDS);
        ExpressionTree superClass = extendsNode != null ? this.classType(extendsNode.getNextSibling()) : null;
        AstNode implementsNode = astNode.getFirstChild(JavaKeyword.IMPLEMENTS);
        ImmutableList<Tree> superInterfaces = implementsNode != null ? this.classTypeList(implementsNode.getNextSibling()) : ImmutableList.of();
        return new JavaTree.ClassTreeImpl(astNode, Tree.Kind.CLASS, modifiers, simpleName, (Tree)superClass, superInterfaces, this.classBody(astNode.getFirstChild(JavaGrammar.CLASS_BODY)));
    }

    private List<Tree> classTypeList(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.CLASS_TYPE_LIST);
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode classTypeNode : astNode.getChildren(JavaGrammar.CLASS_TYPE)) {
            result.add(this.classType(classTypeNode));
        }
        return result.build();
    }

    private List<Tree> classBody(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.CLASS_BODY, JavaGrammar.ENUM_BODY_DECLARATIONS);
        ImmutableList.Builder members = ImmutableList.builder();
        for (AstNode classBodyDeclaration : astNode.getChildren(JavaGrammar.CLASS_BODY_DECLARATION)) {
            ModifiersTree modifiers = this.modifiers(classBodyDeclaration.getChildren(JavaGrammar.MODIFIER));
            if (classBodyDeclaration.hasDirectChildren(JavaGrammar.MEMBER_DECL)) {
                AstNode memberDeclNode = classBodyDeclaration.getFirstChild(JavaGrammar.MEMBER_DECL);
                if (memberDeclNode.hasDirectChildren(JavaGrammar.FIELD_DECLARATION)) {
                    members.addAll(this.fieldDeclaration(modifiers, memberDeclNode.getFirstChild(JavaGrammar.FIELD_DECLARATION)));
                    continue;
                }
                members.add(this.memberDeclaration(modifiers, memberDeclNode));
                continue;
            }
            if (!classBodyDeclaration.getFirstChild().is(JavaGrammar.CLASS_INIT_DECLARATION)) continue;
            AstNode classInitDeclarationNode = classBodyDeclaration.getFirstChild();
            members.add(new JavaTree.BlockTreeImpl(classInitDeclarationNode, classInitDeclarationNode.hasDirectChildren(JavaKeyword.STATIC) ? Tree.Kind.STATIC_INITIALIZER : Tree.Kind.INITIALIZER, this.blockStatements(classInitDeclarationNode.getFirstChild(JavaGrammar.BLOCK).getFirstChild(JavaGrammar.BLOCK_STATEMENTS))));
        }
        return members.build();
    }

    private Tree memberDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.MEMBER_DECL);
        AstNode declaration = astNode.getFirstChild(JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION);
        if (declaration != null) {
            return this.typeDeclaration(modifiers, declaration);
        }
        declaration = astNode.getFirstChild(JavaGrammar.GENERIC_METHOD_OR_CONSTRUCTOR_REST);
        if (declaration != null) {
            return this.methodDeclarator(modifiers, declaration.getFirstChild(JavaGrammar.TYPE, JavaKeyword.VOID), declaration.getFirstChild(JavaTokenType.IDENTIFIER), declaration.getFirstChild(JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST));
        }
        declaration = astNode.getFirstChild(JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST);
        if (declaration != null) {
            return this.methodDeclarator(modifiers, astNode.getFirstChild(JavaGrammar.TYPE, JavaKeyword.VOID), astNode.getFirstChild(JavaTokenType.IDENTIFIER), declaration);
        }
        throw new IllegalStateException();
    }

    private List<StatementTree> fieldDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.FIELD_DECLARATION);
        return this.variableDeclarators(modifiers, this.referenceType(astNode.getFirstChild(JavaGrammar.TYPE)), astNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATORS));
    }

    private MethodTree methodDeclarator(ModifiersTree modifiers, @Nullable AstNode returnTypeNode, AstNode name, AstNode astNode) {
        JavaTreeMaker.checkType(name, JavaTokenType.IDENTIFIER);
        JavaTreeMaker.checkType(astNode, JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST, JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST);
        Object returnType = null;
        if (returnTypeNode != null) {
            returnType = returnTypeNode.is(JavaKeyword.VOID) ? this.basicType(returnTypeNode) : this.referenceType(returnTypeNode);
        }
        BlockTree body = null;
        if (astNode.hasDirectChildren(JavaGrammar.METHOD_BODY)) {
            body = this.block(astNode.getFirstChild(JavaGrammar.METHOD_BODY).getFirstChild(JavaGrammar.BLOCK));
        }
        AstNode throwsClauseNode = astNode.getFirstChild(JavaGrammar.QUALIFIED_IDENTIFIER_LIST);
        return new JavaTree.MethodTreeImpl(astNode, modifiers, (Tree)returnType, name.getTokenValue(), this.formalParameters(astNode.getFirstChild(JavaGrammar.FORMAL_PARAMETERS)), body, throwsClauseNode != null ? this.qualifiedIdentifierList(throwsClauseNode) : ImmutableList.of(), null);
    }

    private List<VariableTree> formalParameters(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.FORMAL_PARAMETERS);
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode variableDeclaratorIdNode : astNode.getDescendants(JavaGrammar.VARIABLE_DECLARATOR_ID)) {
            AstNode typeNode = variableDeclaratorIdNode.getPreviousAstNode();
            JavaTree.ArrayTypeTreeImpl type = typeNode.is(JavaPunctuator.ELLIPSIS) ? new JavaTree.ArrayTypeTreeImpl(typeNode, (Tree)this.referenceType(typeNode.getPreviousAstNode())) : this.referenceType(typeNode);
            result.add(new JavaTree.VariableTreeImpl(variableDeclaratorIdNode, JavaTree.ModifiersTreeImpl.EMPTY, type, variableDeclaratorIdNode.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue(), null));
        }
        return result.build();
    }

    private ClassTree enumDeclaration(ModifiersTree modifiers, AstNode astNode) {
        AstNode implementsNode;
        AstNode enumBodyDeclarationsNode;
        JavaTreeMaker.checkType(astNode, JavaGrammar.ENUM_DECLARATION);
        IdentifierTree enumType = this.identifier(astNode.getFirstChild(JavaTokenType.IDENTIFIER));
        ImmutableList.Builder members = ImmutableList.builder();
        AstNode enumBodyNode = astNode.getFirstChild(JavaGrammar.ENUM_BODY);
        AstNode enumConstantsNode = enumBodyNode.getFirstChild(JavaGrammar.ENUM_CONSTANTS);
        if (enumConstantsNode != null) {
            for (AstNode enumConstantNode : enumConstantsNode.getChildren(JavaGrammar.ENUM_CONSTANT)) {
                AstNode argumentsNode = enumConstantNode.getFirstChild(JavaGrammar.ARGUMENTS);
                AstNode classBodyNode = enumConstantNode.getFirstChild(JavaGrammar.CLASS_BODY);
                IdentifierTree enumIdentifier = this.identifier(enumConstantNode.getFirstChild(JavaTokenType.IDENTIFIER));
                members.add(new JavaTree.EnumConstantTreeImpl(enumConstantNode, JavaTree.ModifiersTreeImpl.EMPTY, (Tree)enumType, enumIdentifier.name(), (ExpressionTree)new JavaTree.NewClassTreeImpl(enumConstantNode, null, (ExpressionTree)enumIdentifier, argumentsNode != null ? this.arguments(argumentsNode) : ImmutableList.of(), classBodyNode == null ? null : new JavaTree.ClassTreeImpl(classBodyNode, Tree.Kind.CLASS, JavaTree.ModifiersTreeImpl.EMPTY, this.classBody(classBodyNode)))));
            }
        }
        if ((enumBodyDeclarationsNode = enumBodyNode.getFirstChild(JavaGrammar.ENUM_BODY_DECLARATIONS)) != null) {
            members.addAll(this.classBody(enumBodyDeclarationsNode));
        }
        ImmutableList<Tree> superInterfaces = (implementsNode = astNode.getFirstChild(JavaKeyword.IMPLEMENTS)) != null ? this.classTypeList(implementsNode.getNextSibling()) : ImmutableList.of();
        return new JavaTree.ClassTreeImpl(astNode, Tree.Kind.ENUM, modifiers, enumType.name(), null, superInterfaces, (List<Tree>)((Object)members.build()));
    }

    private ClassTree interfaceDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.INTERFACE_DECLARATION);
        String simpleName = astNode.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue();
        ImmutableList.Builder<Tree> members = ImmutableList.builder();
        for (AstNode interfaceBodyDeclarationNode : astNode.getFirstChild(JavaGrammar.INTERFACE_BODY).getChildren(JavaGrammar.INTERFACE_BODY_DECLARATION)) {
            ModifiersTree memberModifiers = this.modifiers(interfaceBodyDeclarationNode.getChildren(JavaGrammar.MODIFIER));
            AstNode interfaceMemberDeclNode = interfaceBodyDeclarationNode.getFirstChild(JavaGrammar.INTERFACE_MEMBER_DECL);
            if (interfaceMemberDeclNode == null) continue;
            this.appendInterfaceMember(memberModifiers, members, interfaceMemberDeclNode);
        }
        AstNode extendsNode = astNode.getFirstChild(JavaKeyword.EXTENDS);
        ImmutableList<Tree> superInterfaces = extendsNode != null ? this.classTypeList(extendsNode.getNextSibling()) : ImmutableList.of();
        return new JavaTree.ClassTreeImpl(astNode, Tree.Kind.INTERFACE, modifiers, simpleName, null, superInterfaces, (List<Tree>)((Object)members.build()));
    }

    private void appendInterfaceMember(ModifiersTree modifiers, ImmutableList.Builder<Tree> members, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.INTERFACE_MEMBER_DECL);
        AstNode declarationNode = astNode.getFirstChild(JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION);
        if (declarationNode != null) {
            members.add(this.typeDeclaration(modifiers, declarationNode));
            return;
        }
        declarationNode = astNode.getFirstChild(JavaGrammar.INTERFACE_METHOD_OR_FIELD_DECL);
        if (declarationNode != null) {
            AstNode interfaceMethodOrFieldRestNode = declarationNode.getFirstChild(JavaGrammar.INTERFACE_METHOD_OR_FIELD_REST);
            AstNode interfaceMethodDeclaratorRestNode = interfaceMethodOrFieldRestNode.getFirstChild(JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST);
            if (interfaceMethodDeclaratorRestNode != null) {
                members.add(this.methodDeclarator(modifiers, declarationNode.getFirstChild(JavaGrammar.TYPE, JavaKeyword.VOID), declarationNode.getFirstChild(JavaTokenType.IDENTIFIER), interfaceMethodDeclaratorRestNode));
                return;
            }
            this.appendConstantDeclarations(modifiers, members, declarationNode);
            return;
        }
        declarationNode = astNode.getFirstChild(JavaGrammar.INTERFACE_GENERIC_METHOD_DECL);
        if (declarationNode != null) {
            members.add(this.methodDeclarator(modifiers, declarationNode.getFirstChild(JavaGrammar.TYPE, JavaKeyword.VOID), declarationNode.getFirstChild(JavaTokenType.IDENTIFIER), declarationNode.getFirstChild(JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST)));
            return;
        }
        declarationNode = astNode.getFirstChild(JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST);
        if (declarationNode != null) {
            members.add(this.methodDeclarator(modifiers, astNode.getFirstChild(JavaKeyword.VOID), astNode.getFirstChild(JavaTokenType.IDENTIFIER), declarationNode));
            return;
        }
        throw new IllegalStateException();
    }

    private void appendConstantDeclarations(ModifiersTree modifiers, ImmutableList.Builder<Tree> members, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.INTERFACE_METHOD_OR_FIELD_DECL, JavaGrammar.ANNOTATION_TYPE_ELEMENT_REST);
        ExpressionTree type = this.referenceType(astNode.getFirstChild(JavaGrammar.TYPE, JavaKeyword.VOID));
        for (AstNode constantDeclaratorRestNode : astNode.getDescendants(JavaGrammar.CONSTANT_DECLARATOR_REST)) {
            AstNode identifierNode = constantDeclaratorRestNode.getPreviousAstNode();
            Preconditions.checkState(identifierNode.is(JavaTokenType.IDENTIFIER));
            members.add((Object)new JavaTree.VariableTreeImpl(constantDeclaratorRestNode, modifiers, (Tree)this.applyDim(type, constantDeclaratorRestNode.getChildren(JavaGrammar.DIM).size()), identifierNode.getTokenValue(), this.variableInitializer(constantDeclaratorRestNode.getFirstChild(JavaGrammar.VARIABLE_INITIALIZER))));
        }
    }

    private ClassTree annotationTypeDeclaration(ModifiersTree modifiers, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.ANNOTATION_TYPE_DECLARATION);
        String simpleName = astNode.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue();
        ImmutableList.Builder<Tree> members = ImmutableList.builder();
        for (AstNode annotationTypeElementDeclarationNode : astNode.getFirstChild(JavaGrammar.ANNOTATION_TYPE_BODY).getChildren(JavaGrammar.ANNOTATION_TYPE_ELEMENT_DECLARATION)) {
            AstNode annotationTypeElementRestNode = annotationTypeElementDeclarationNode.getFirstChild(JavaGrammar.ANNOTATION_TYPE_ELEMENT_REST);
            if (annotationTypeElementRestNode == null) continue;
            this.appendAnnotationTypeElementDeclaration(members, annotationTypeElementRestNode);
        }
        return new JavaTree.ClassTreeImpl(astNode, Tree.Kind.ANNOTATION_TYPE, modifiers, simpleName, null, ImmutableList.<Tree>of(), (List<Tree>)((Object)members.build()));
    }

    private void appendAnnotationTypeElementDeclaration(ImmutableList.Builder<Tree> members, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.ANNOTATION_TYPE_ELEMENT_REST);
        AstNode declarationNode = astNode.getFirstChild(JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION);
        if (declarationNode != null) {
            members.add(this.typeDeclaration(JavaTree.ModifiersTreeImpl.EMPTY, declarationNode));
            return;
        }
        AstNode typeNode = astNode.getFirstChild(JavaGrammar.TYPE);
        AstNode identifierNode = astNode.getFirstChild(JavaTokenType.IDENTIFIER);
        AstNode annotationMethodRestNode = astNode.getFirstChild(JavaGrammar.ANNOTATION_METHOD_OR_CONSTANT_REST).getFirstChild(JavaGrammar.ANNOTATION_METHOD_REST);
        if (annotationMethodRestNode != null) {
            members.add((Object)new JavaTree.MethodTreeImpl(annotationMethodRestNode, JavaTree.ModifiersTreeImpl.EMPTY, (Tree)this.referenceType(typeNode), identifierNode.getTokenValue(), ImmutableList.<VariableTree>of(), null, ImmutableList.<ExpressionTree>of(), null));
        } else {
            this.appendConstantDeclarations(JavaTree.ModifiersTreeImpl.EMPTY, members, astNode);
        }
    }

    @VisibleForTesting
    BlockTree block(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.BLOCK);
        return new JavaTree.BlockTreeImpl(astNode, Tree.Kind.BLOCK, this.blockStatements(astNode.getFirstChild(JavaGrammar.BLOCK_STATEMENTS)));
    }

    private List<StatementTree> blockStatements(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.BLOCK_STATEMENTS);
        ImmutableList.Builder statements = ImmutableList.builder();
        for (AstNode statementNode : astNode.getChildren(JavaGrammar.BLOCK_STATEMENT)) {
            statementNode = statementNode.getFirstChild(JavaGrammar.STATEMENT, JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT, JavaGrammar.CLASS_DECLARATION, JavaGrammar.ENUM_DECLARATION);
            if (statementNode.is(JavaGrammar.STATEMENT)) {
                statements.add(this.statement(statementNode));
                continue;
            }
            if (statementNode.is(JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT)) {
                statements.addAll(this.variableDeclarators(JavaTree.ModifiersTreeImpl.EMPTY, this.referenceType(statementNode.getFirstChild(JavaGrammar.TYPE)), statementNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATORS)));
                continue;
            }
            if (statementNode.is(JavaGrammar.CLASS_DECLARATION)) {
                statements.add(this.classDeclaration(JavaTree.ModifiersTreeImpl.EMPTY, statementNode));
                continue;
            }
            if (statementNode.is(JavaGrammar.ENUM_DECLARATION)) {
                statements.add(this.enumDeclaration(JavaTree.ModifiersTreeImpl.EMPTY, statementNode));
                continue;
            }
            throw new IllegalStateException("Unexpected AstNodeType: " + statementNode.getType().toString());
        }
        return statements.build();
    }

    @VisibleForTesting
    StatementTree statement(AstNode astNode) {
        Object result;
        JavaTreeMaker.checkType(astNode, JavaGrammar.STATEMENT);
        AstNode statementNode = astNode.getFirstChild();
        switch ((JavaGrammar)statementNode.getType()) {
            case BLOCK: {
                result = this.block(statementNode);
                break;
            }
            case EMPTY_STATEMENT: {
                result = new JavaTree.EmptyStatementTreeImpl(statementNode);
                break;
            }
            case LABELED_STATEMENT: {
                result = new JavaTree.LabeledStatementTreeImpl(statementNode, statementNode.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue(), this.statement(statementNode.getFirstChild(JavaGrammar.STATEMENT)));
                break;
            }
            case EXPRESSION_STATEMENT: {
                result = new JavaTree.ExpressionStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(JavaGrammar.STATEMENT_EXPRESSION)));
                break;
            }
            case IF_STATEMENT: {
                List<AstNode> statements = statementNode.getChildren(JavaGrammar.STATEMENT);
                result = new JavaTree.IfStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(JavaGrammar.PAR_EXPRESSION)), this.statement(statements.get(0)), statements.size() > 1 ? this.statement(statements.get(1)) : null);
                break;
            }
            case ASSERT_STATEMENT: {
                List<AstNode> expressions = statementNode.getChildren(JavaGrammar.EXPRESSION);
                result = new JavaTree.AssertStatementTreeImpl(statementNode, this.expression(expressions.get(0)), expressions.size() > 1 ? this.expression(expressions.get(1)) : null);
                break;
            }
            case SWITCH_STATEMENT: {
                result = this.switchStatement(statementNode);
                break;
            }
            case WHILE_STATEMENT: {
                result = new JavaTree.WhileStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(JavaGrammar.PAR_EXPRESSION)), this.statement(statementNode.getFirstChild(JavaGrammar.STATEMENT)));
                break;
            }
            case DO_STATEMENT: {
                result = new JavaTree.DoWhileStatementTreeImpl(statementNode, this.statement(statementNode.getFirstChild(JavaGrammar.STATEMENT)), this.expression(statementNode.getFirstChild(JavaGrammar.PAR_EXPRESSION)));
                break;
            }
            case FOR_STATEMENT: {
                result = this.forStatement(statementNode);
                break;
            }
            case BREAK_STATEMENT: {
                result = new JavaTree.BreakStatementTreeImpl(statementNode, statementNode.hasDirectChildren(JavaTokenType.IDENTIFIER) ? statementNode.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue() : null);
                break;
            }
            case CONTINUE_STATEMENT: {
                result = new JavaTree.ContinueStatementTreeImpl(statementNode, statementNode.hasDirectChildren(JavaTokenType.IDENTIFIER) ? statementNode.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue() : null);
                break;
            }
            case RETURN_STATEMENT: {
                result = new JavaTree.ReturnStatementTreeImpl(statementNode, statementNode.hasDirectChildren(JavaGrammar.EXPRESSION) ? this.expression(statementNode.getFirstChild(JavaGrammar.EXPRESSION)) : null);
                break;
            }
            case THROW_STATEMENT: {
                result = new JavaTree.ThrowStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(JavaGrammar.EXPRESSION)));
                break;
            }
            case SYNCHRONIZED_STATEMENT: {
                result = new JavaTree.SynchronizedStatementTreeImpl(statementNode, this.expression(statementNode.getFirstChild(JavaGrammar.PAR_EXPRESSION)), this.block(statementNode.getFirstChild(JavaGrammar.BLOCK)));
                break;
            }
            case TRY_STATEMENT: {
                result = this.tryStatement(statementNode);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected AstNodeType: " + astNode.getType().toString());
            }
        }
        return result;
    }

    private SwitchStatementTree switchStatement(AstNode astNode) {
        ImmutableList.Builder cases = ImmutableList.builder();
        ArrayList<JavaTree.CaseLabelTreeImpl> labels = Lists.newArrayList();
        for (AstNode caseNode : astNode.getFirstChild(JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUPS).getChildren(JavaGrammar.SWITCH_BLOCK_STATEMENT_GROUP)) {
            AstNode expressionNode = caseNode.getFirstChild(JavaGrammar.SWITCH_LABEL).getFirstChild(JavaGrammar.CONSTANT_EXPRESSION);
            AstNode blockStatementsNode = caseNode.getFirstChild(JavaGrammar.BLOCK_STATEMENTS);
            labels.add(new JavaTree.CaseLabelTreeImpl(caseNode, expressionNode != null ? this.expression(expressionNode) : null));
            if (!blockStatementsNode.hasChildren()) continue;
            cases.add(new JavaTree.CaseGroupTreeImpl(((JavaTree.CaseLabelTreeImpl)labels.get(0)).getAstNode(), ImmutableList.copyOf(labels), this.blockStatements(caseNode.getFirstChild(JavaGrammar.BLOCK_STATEMENTS))));
            labels.clear();
        }
        if (!labels.isEmpty()) {
            cases.add(new JavaTree.CaseGroupTreeImpl(((JavaTree.CaseLabelTreeImpl)labels.get(0)).getAstNode(), ImmutableList.copyOf(labels), ImmutableList.<StatementTree>of()));
        }
        return new JavaTree.SwitchStatementTreeImpl(astNode, this.expression(astNode.getFirstChild(JavaGrammar.PAR_EXPRESSION)), (List<CaseGroupTree>)((Object)cases.build()));
    }

    private StatementTree forStatement(AstNode astNode) {
        AstNode formalParameterNode = astNode.getFirstChild(JavaGrammar.FORMAL_PARAMETER);
        if (formalParameterNode == null) {
            AstNode forInitNode = astNode.getFirstChild(JavaGrammar.FOR_INIT);
            List<StatementTree> forInit = forInitNode == null ? ImmutableList.of() : (forInitNode.hasDirectChildren(JavaGrammar.VARIABLE_DECLARATORS) ? this.variableDeclarators(JavaTree.ModifiersTreeImpl.EMPTY, this.referenceType(forInitNode.getFirstChild(JavaGrammar.TYPE)), forInitNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATORS)) : this.statementExpressions(astNode.getFirstChild(JavaGrammar.FOR_INIT)));
            return new JavaTree.ForStatementTreeImpl(astNode, forInit, astNode.hasDirectChildren(JavaGrammar.EXPRESSION) ? this.expression(astNode.getFirstChild(JavaGrammar.EXPRESSION)) : null, astNode.hasDirectChildren(JavaGrammar.FOR_UPDATE) ? this.statementExpressions(astNode.getFirstChild(JavaGrammar.FOR_UPDATE)) : ImmutableList.of(), this.statement(astNode.getFirstChild(JavaGrammar.STATEMENT)));
        }
        return new JavaTree.ForEachStatementImpl(astNode, new JavaTree.VariableTreeImpl(formalParameterNode, JavaTree.ModifiersTreeImpl.EMPTY, (Tree)this.referenceType(formalParameterNode.getFirstChild(JavaGrammar.TYPE)), formalParameterNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATOR_ID).getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue(), null), this.expression(astNode.getFirstChild(JavaGrammar.EXPRESSION)), this.statement(astNode.getFirstChild(JavaGrammar.STATEMENT)));
    }

    private List<StatementTree> statementExpressions(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.FOR_INIT, JavaGrammar.FOR_UPDATE);
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode statementExpressionNode : astNode.getChildren(JavaGrammar.STATEMENT_EXPRESSION)) {
            result.add(new JavaTree.ExpressionStatementTreeImpl(statementExpressionNode, this.expression(statementExpressionNode)));
        }
        return result.build();
    }

    private TryStatementTree tryStatement(AstNode astNode) {
        AstNode resourceSpecificationNode;
        if (astNode.hasDirectChildren(JavaGrammar.TRY_WITH_RESOURCES_STATEMENT)) {
            astNode = astNode.getFirstChild(JavaGrammar.TRY_WITH_RESOURCES_STATEMENT);
        }
        ImmutableList.Builder catches = ImmutableList.builder();
        for (AstNode catchNode : astNode.getChildren(JavaGrammar.CATCH_CLAUSE)) {
            AstNode catchFormalParameterNode = catchNode.getFirstChild(JavaGrammar.CATCH_FORMAL_PARAMETER);
            catches.add(new JavaTree.CatchTreeImpl(catchNode, new JavaTree.VariableTreeImpl(catchFormalParameterNode, JavaTree.ModifiersTreeImpl.EMPTY, this.catchType(catchFormalParameterNode.getFirstChild(JavaGrammar.CATCH_TYPE)), catchFormalParameterNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATOR_ID).getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue(), null), this.block(catchNode.getFirstChild(JavaGrammar.BLOCK))));
        }
        BlockTree finallyBlock = null;
        if (astNode.hasDirectChildren(JavaGrammar.FINALLY_)) {
            finallyBlock = this.block(astNode.getFirstChild(JavaGrammar.FINALLY_).getFirstChild(JavaGrammar.BLOCK));
        }
        return new JavaTree.TryStatementTreeImpl(astNode, (resourceSpecificationNode = astNode.getFirstChild(JavaGrammar.RESOURCE_SPECIFICATION)) == null ? ImmutableList.of() : this.resourceSpecification(resourceSpecificationNode), this.block(astNode.getFirstChild(JavaGrammar.BLOCK)), (List<CatchTree>)((Object)catches.build()), finallyBlock);
    }

    private Tree catchType(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.CATCH_TYPE);
        List<AstNode> children = astNode.getChildren(JavaGrammar.QUALIFIED_IDENTIFIER);
        if (children.size() == 1) {
            return this.qualifiedIdentifier(children.get(0));
        }
        ImmutableList.Builder typeAlternatives = ImmutableList.builder();
        for (AstNode child : children) {
            typeAlternatives.add(this.qualifiedIdentifier(child));
        }
        return new JavaTree.UnionTypeTreeImpl(astNode, (List<Tree>)((Object)typeAlternatives.build()));
    }

    private List<VariableTree> resourceSpecification(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.RESOURCE_SPECIFICATION);
        ImmutableList.Builder result = ImmutableList.builder();
        for (AstNode resourceNode : astNode.getChildren(JavaGrammar.RESOURCE)) {
            result.add(new JavaTree.VariableTreeImpl(resourceNode, JavaTree.ModifiersTreeImpl.EMPTY, (Tree)this.classType(resourceNode.getFirstChild(JavaGrammar.CLASS_TYPE)), resourceNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATOR_ID).getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue(), this.expression(resourceNode.getFirstChild(JavaGrammar.EXPRESSION))));
        }
        return result.build();
    }

    @VisibleForTesting
    ExpressionTree expression(AstNode astNode) {
        if (astNode.is(JavaGrammar.CONSTANT_EXPRESSION, JavaGrammar.STATEMENT_EXPRESSION)) {
            astNode = astNode.getFirstChild(JavaGrammar.EXPRESSION).getFirstChild();
        } else if (astNode.is(JavaGrammar.EXPRESSION)) {
            astNode = astNode.getFirstChild();
        }
        if (astNode.is(JavaGrammar.PAR_EXPRESSION)) {
            return new JavaTree.ParenthesizedTreeImpl(astNode, this.expression(astNode.getFirstChild(JavaGrammar.EXPRESSION)));
        }
        if (astNode.is(JavaGrammar.PRIMARY)) {
            return this.primary(astNode);
        }
        if (astNode.is(JavaGrammar.CONDITIONAL_OR_EXPRESSION, JavaGrammar.CONDITIONAL_AND_EXPRESSION, JavaGrammar.INCLUSIVE_OR_EXPRESSION, JavaGrammar.EXCLUSIVE_OR_EXPRESSION, JavaGrammar.AND_EXPRESSION, JavaGrammar.EQUALITY_EXPRESSION, JavaGrammar.RELATIONAL_EXPRESSION, JavaGrammar.SHIFT_EXPRESSION, JavaGrammar.ADDITIVE_EXPRESSION, JavaGrammar.MULTIPLICATIVE_EXPRESSION)) {
            return this.binaryExpression(astNode);
        }
        if (astNode.is(JavaGrammar.CONDITIONAL_EXPRESSION)) {
            return this.conditionalExpression(astNode);
        }
        if (astNode.is(JavaGrammar.ASSIGNMENT_EXPRESSION)) {
            return this.assignmentExpression(astNode);
        }
        if (astNode.is(JavaGrammar.UNARY_EXPRESSION)) {
            return this.unaryExpression(astNode);
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType().toString());
    }

    @VisibleForTesting
    ExpressionTree primary(AstNode astNode) {
        AstNode firstChildNode = astNode.getFirstChild();
        if (firstChildNode.is(JavaGrammar.PAR_EXPRESSION)) {
            return this.expression(firstChildNode);
        }
        if (firstChildNode.is(JavaGrammar.NON_WILDCARD_TYPE_ARGUMENTS)) {
            if (astNode.hasDirectChildren(JavaKeyword.THIS)) {
                return new JavaTree.MethodInvocationTreeImpl(astNode, (ExpressionTree)this.identifier(astNode.getFirstChild(JavaKeyword.THIS)), this.arguments(astNode.getFirstChild(JavaGrammar.ARGUMENTS)));
            }
            AstNode explicitGenericInvocationSuffixNode = astNode.getFirstChild(JavaGrammar.EXPLICIT_GENERIC_INVOCATION_SUFFIX);
            if (explicitGenericInvocationSuffixNode.hasDirectChildren(JavaKeyword.SUPER)) {
                return this.applySuperSuffix((ExpressionTree)this.identifier(explicitGenericInvocationSuffixNode.getFirstChild(JavaKeyword.SUPER)), explicitGenericInvocationSuffixNode.getFirstChild(JavaGrammar.SUPER_SUFFIX));
            }
            return new JavaTree.MethodInvocationTreeImpl(astNode, (ExpressionTree)this.identifier(explicitGenericInvocationSuffixNode.getFirstChild(JavaTokenType.IDENTIFIER)), this.arguments(explicitGenericInvocationSuffixNode.getFirstChild(JavaGrammar.ARGUMENTS)));
        }
        if (firstChildNode.is(JavaKeyword.THIS)) {
            IdentifierTree identifier = this.identifier(firstChildNode);
            if (astNode.hasDirectChildren(JavaGrammar.ARGUMENTS)) {
                return new JavaTree.MethodInvocationTreeImpl(astNode, (ExpressionTree)identifier, this.arguments(astNode.getFirstChild(JavaGrammar.ARGUMENTS)));
            }
            return identifier;
        }
        if (firstChildNode.is(JavaKeyword.SUPER)) {
            return this.applySuperSuffix((ExpressionTree)this.identifier(firstChildNode), astNode.getFirstChild(JavaGrammar.SUPER_SUFFIX));
        }
        if (firstChildNode.is(JavaGrammar.LITERAL)) {
            return this.literal(firstChildNode);
        }
        if (firstChildNode.is(JavaKeyword.NEW)) {
            return this.creator(astNode.getFirstChild(JavaGrammar.CREATOR));
        }
        if (firstChildNode.is(JavaGrammar.QUALIFIED_IDENTIFIER)) {
            ExpressionTree identifier = this.qualifiedIdentifier(firstChildNode);
            AstNode identifierSuffixNode = astNode.getFirstChild(JavaGrammar.IDENTIFIER_SUFFIX);
            if (identifierSuffixNode == null) {
                return identifier;
            }
            if (identifierSuffixNode.getFirstChild().is(JavaPunctuator.LBRK)) {
                if (identifierSuffixNode.hasDirectChildren(JavaKeyword.CLASS)) {
                    return new JavaTree.MemberSelectExpressionTreeImpl(astNode, this.applyDim(identifier, identifierSuffixNode.getChildren(JavaGrammar.DIM).size() + 1), this.identifier(identifierSuffixNode.getFirstChild(JavaKeyword.CLASS)));
                }
                return new JavaTree.ArrayAccessExpressionTreeImpl(astNode, identifier, this.expression(identifierSuffixNode.getFirstChild(JavaGrammar.EXPRESSION)));
            }
            if (identifierSuffixNode.getFirstChild().is(JavaGrammar.ARGUMENTS)) {
                return new JavaTree.MethodInvocationTreeImpl(astNode, identifier, this.arguments(identifierSuffixNode.getFirstChild()));
            }
            if (identifierSuffixNode.getFirstChild().is(JavaPunctuator.DOT)) {
                if (identifierSuffixNode.hasDirectChildren(JavaKeyword.CLASS)) {
                    return new JavaTree.MemberSelectExpressionTreeImpl(astNode, identifier, this.identifier(identifierSuffixNode.getFirstChild(JavaKeyword.CLASS)));
                }
                if (identifierSuffixNode.hasDirectChildren(JavaGrammar.EXPLICIT_GENERIC_INVOCATION)) {
                    return this.applyExplicitGenericInvocation(identifier, identifierSuffixNode.getFirstChild(JavaGrammar.EXPLICIT_GENERIC_INVOCATION));
                }
                if (identifierSuffixNode.hasDirectChildren(JavaKeyword.THIS)) {
                    return new JavaTree.MemberSelectExpressionTreeImpl(astNode, identifier, this.identifier(identifierSuffixNode.getFirstChild(JavaKeyword.THIS)));
                }
                if (identifierSuffixNode.hasDirectChildren(JavaKeyword.SUPER)) {
                    return new JavaTree.MethodInvocationTreeImpl(astNode, (ExpressionTree)new JavaTree.MemberSelectExpressionTreeImpl(astNode, identifier, this.identifier(identifierSuffixNode.getFirstChild(JavaKeyword.SUPER))), this.arguments(identifierSuffixNode.getFirstChild(JavaGrammar.ARGUMENTS)));
                }
                if (identifierSuffixNode.hasDirectChildren(JavaKeyword.NEW)) {
                    AstNode innerCreatorNode = identifierSuffixNode.getFirstChild(JavaGrammar.INNER_CREATOR);
                    return this.applyClassCreatorRest(identifier, (ExpressionTree)this.identifier(innerCreatorNode.getFirstChild(JavaTokenType.IDENTIFIER)), innerCreatorNode.getFirstChild(JavaGrammar.CLASS_CREATOR_REST));
                }
                throw new IllegalArgumentException("Unexpected AstNodeType: " + identifierSuffixNode.getChild(1));
            }
            throw new IllegalArgumentException("Unexpected AstNodeType: " + identifierSuffixNode.getFirstChild());
        }
        if (firstChildNode.is(JavaGrammar.BASIC_TYPE, JavaKeyword.VOID)) {
            return new JavaTree.MemberSelectExpressionTreeImpl(astNode, this.applyDim((ExpressionTree)this.basicType(firstChildNode), astNode.getChildren(JavaGrammar.DIM).size()), this.identifier(astNode.getFirstChild(JavaKeyword.CLASS)));
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + firstChildNode.getType());
    }

    private ExpressionTree creator(AstNode astNode) {
        if (astNode.hasDirectChildren(JavaGrammar.CLASS_CREATOR_REST)) {
            return this.applyClassCreatorRest(null, this.classType(astNode.getFirstChild(JavaGrammar.CREATED_NAME)), astNode.getFirstChild(JavaGrammar.CLASS_CREATOR_REST));
        }
        if (astNode.hasDirectChildren(JavaGrammar.ARRAY_CREATOR_REST)) {
            PrimitiveTypeTree type;
            AstNode arrayCreatorRestNode = astNode.getFirstChild(JavaGrammar.ARRAY_CREATOR_REST);
            AstNode typeNode = arrayCreatorRestNode.getPreviousSibling();
            Object object = type = typeNode.is(JavaGrammar.BASIC_TYPE) ? this.basicType(typeNode) : this.classType(typeNode);
            if (arrayCreatorRestNode.hasDirectChildren(JavaGrammar.ARRAY_INITIALIZER)) {
                return this.arrayInitializer((Tree)type, arrayCreatorRestNode.getFirstChild(JavaGrammar.ARRAY_INITIALIZER));
            }
            ImmutableList.Builder dimensions = ImmutableList.builder();
            dimensions.add(this.expression(arrayCreatorRestNode.getFirstChild(JavaGrammar.EXPRESSION)));
            for (AstNode dimExpr : arrayCreatorRestNode.getChildren(JavaGrammar.DIM_EXPR)) {
                dimensions.add(this.expression(dimExpr.getFirstChild(JavaGrammar.EXPRESSION)));
            }
            return new JavaTree.NewArrayTreeImpl(astNode, (Tree)type, (List<ExpressionTree>)((Object)dimensions.build()), ImmutableList.<ExpressionTree>of());
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode);
    }

    private ExpressionTree arrayInitializer(@Nullable Tree t, AstNode astNode) {
        ImmutableList.Builder elems = ImmutableList.builder();
        for (AstNode elem : astNode.getChildren(JavaGrammar.VARIABLE_INITIALIZER)) {
            elems.add(this.variableInitializer(elem));
        }
        return new JavaTree.NewArrayTreeImpl(astNode, t, ImmutableList.<ExpressionTree>of(), (List<ExpressionTree>)((Object)elems.build()));
    }

    private ExpressionTree variableInitializer(AstNode astNode) {
        if (astNode.getFirstChild().is(JavaGrammar.EXPRESSION)) {
            return this.expression(astNode.getFirstChild());
        }
        return this.arrayInitializer(null, astNode.getFirstChild());
    }

    private ExpressionTree unaryExpression(AstNode astNode) {
        if (astNode.hasDirectChildren(JavaGrammar.TYPE)) {
            return new JavaTree.TypeCastExpressionTreeImpl(astNode, (Tree)this.referenceType(astNode.getFirstChild(JavaGrammar.TYPE)), this.expression(astNode.getChild(3)));
        }
        if (astNode.hasDirectChildren(JavaGrammar.PREFIX_OP)) {
            JavaPunctuator punctuator = (JavaPunctuator)astNode.getFirstChild(JavaGrammar.PREFIX_OP).getFirstChild().getType();
            Tree.Kind kind = this.kindMaps.getPrefixOperator(punctuator);
            return new JavaTree.UnaryExpressionTreeImpl(astNode, kind, this.expression(astNode.getChild(1)));
        }
        Object result = this.expression(astNode.getFirstChild());
        for (AstNode selectorNode : astNode.getChildren(JavaGrammar.SELECTOR)) {
            result = this.applySelector((ExpressionTree)result, selectorNode);
        }
        for (AstNode postfixOpNode : astNode.getChildren(JavaGrammar.POST_FIX_OP)) {
            JavaPunctuator punctuator = (JavaPunctuator)postfixOpNode.getFirstChild().getType();
            Tree.Kind kind = this.kindMaps.getPostfixOperator(punctuator);
            result = new JavaTree.UnaryExpressionTreeImpl(astNode, kind, (ExpressionTree)result);
        }
        return result;
    }

    private ExpressionTree binaryExpression(AstNode astNode) {
        if (astNode.hasDirectChildren(JavaKeyword.INSTANCEOF)) {
            return new JavaTree.InstanceOfTreeImpl(astNode, this.expression(astNode.getFirstChild()), (Tree)this.referenceType(astNode.getFirstChild(JavaGrammar.REFERENCE_TYPE)));
        }
        Object expression = this.expression(astNode.getLastChild());
        for (int i = astNode.getNumberOfChildren() - 3; i >= 0; i -= 2) {
            JavaPunctuator punctuator = (JavaPunctuator)astNode.getChild(i + 1).getType();
            Tree.Kind kind = this.kindMaps.getBinaryOperator(punctuator);
            expression = new JavaTree.BinaryExpressionTreeImpl(astNode, this.expression(astNode.getChild(i)), kind, (ExpressionTree)expression);
        }
        return expression;
    }

    private ExpressionTree conditionalExpression(AstNode astNode) {
        Object expression = this.expression(astNode.getLastChild());
        for (int i = astNode.getNumberOfChildren() - 5; i >= 0; i -= 4) {
            expression = new JavaTree.ConditionalExpressionTreeImpl(astNode, this.expression(astNode.getChild(i)), this.expression(astNode.getChild(i + 2)), (ExpressionTree)expression);
        }
        return expression;
    }

    private ExpressionTree assignmentExpression(AstNode astNode) {
        Object expression = this.expression(astNode.getLastChild());
        for (int i = astNode.getNumberOfChildren() - 3; i >= 0; i -= 2) {
            JavaPunctuator punctuator = (JavaPunctuator)astNode.getChild(i + 1).getFirstChild().getType();
            Tree.Kind kind = this.kindMaps.getAssignmentOperator(punctuator);
            expression = new JavaTree.AssignmentExpressionTreeImpl(astNode, this.expression(astNode.getChild(i)), kind, (ExpressionTree)expression);
        }
        return expression;
    }

    private ExpressionTree applySelector(ExpressionTree expression, AstNode selectorNode) {
        JavaTreeMaker.checkType(selectorNode, JavaGrammar.SELECTOR);
        if (selectorNode.hasDirectChildren(JavaGrammar.ARGUMENTS)) {
            return new JavaTree.MethodInvocationTreeImpl(selectorNode, (ExpressionTree)new JavaTree.MemberSelectExpressionTreeImpl(selectorNode, expression, this.identifier(selectorNode.getFirstChild(JavaTokenType.IDENTIFIER))), this.arguments(selectorNode.getFirstChild(JavaGrammar.ARGUMENTS)));
        }
        if (selectorNode.hasDirectChildren(JavaTokenType.IDENTIFIER)) {
            return new JavaTree.MemberSelectExpressionTreeImpl(selectorNode, expression, this.identifier(selectorNode.getFirstChild(JavaTokenType.IDENTIFIER)));
        }
        if (selectorNode.hasDirectChildren(JavaGrammar.EXPLICIT_GENERIC_INVOCATION)) {
            return this.applyExplicitGenericInvocation(expression, selectorNode.getFirstChild(JavaGrammar.EXPLICIT_GENERIC_INVOCATION));
        }
        if (selectorNode.hasDirectChildren(JavaKeyword.THIS)) {
            return new JavaTree.MemberSelectExpressionTreeImpl(selectorNode, expression, this.identifier(selectorNode.getFirstChild(JavaKeyword.THIS)));
        }
        if (selectorNode.hasDirectChildren(JavaGrammar.SUPER_SUFFIX)) {
            return this.applySuperSuffix((ExpressionTree)new JavaTree.MemberSelectExpressionTreeImpl(selectorNode, expression, this.identifier(selectorNode.getFirstChild(JavaKeyword.SUPER))), selectorNode.getFirstChild(JavaGrammar.SUPER_SUFFIX));
        }
        if (selectorNode.hasDirectChildren(JavaKeyword.NEW)) {
            AstNode innerCreatorNode = selectorNode.getFirstChild(JavaGrammar.INNER_CREATOR);
            return this.applyClassCreatorRest(expression, (ExpressionTree)this.identifier(innerCreatorNode.getFirstChild(JavaTokenType.IDENTIFIER)), innerCreatorNode.getFirstChild(JavaGrammar.CLASS_CREATOR_REST));
        }
        if (selectorNode.hasDirectChildren(JavaGrammar.DIM_EXPR)) {
            return new JavaTree.ArrayAccessExpressionTreeImpl(selectorNode, expression, this.expression(selectorNode.getFirstChild(JavaGrammar.DIM_EXPR).getFirstChild(JavaGrammar.EXPRESSION)));
        }
        throw new IllegalStateException(AstXmlPrinter.print(selectorNode));
    }

    private ExpressionTree applySuperSuffix(ExpressionTree expression, AstNode superSuffixNode) {
        JavaTreeMaker.checkType(superSuffixNode, JavaGrammar.SUPER_SUFFIX);
        if (superSuffixNode.hasDirectChildren(JavaGrammar.ARGUMENTS)) {
            Object methodSelect = expression;
            if (superSuffixNode.hasDirectChildren(JavaTokenType.IDENTIFIER)) {
                methodSelect = new JavaTree.MemberSelectExpressionTreeImpl(superSuffixNode, expression, this.identifier(superSuffixNode.getFirstChild(JavaTokenType.IDENTIFIER)));
            }
            return new JavaTree.MethodInvocationTreeImpl(superSuffixNode, (ExpressionTree)methodSelect, this.arguments(superSuffixNode.getFirstChild(JavaGrammar.ARGUMENTS)));
        }
        return new JavaTree.MemberSelectExpressionTreeImpl(superSuffixNode, expression, this.identifier(superSuffixNode.getFirstChild(JavaTokenType.IDENTIFIER)));
    }

    private ExpressionTree applyClassCreatorRest(ExpressionTree enclosingExpression, ExpressionTree identifier, AstNode classCreatorRestNode) {
        JavaTreeMaker.checkType(classCreatorRestNode, JavaGrammar.CLASS_CREATOR_REST);
        JavaTree.ClassTreeImpl classBody = null;
        if (classCreatorRestNode.hasDirectChildren(JavaGrammar.CLASS_BODY)) {
            classBody = new JavaTree.ClassTreeImpl(classCreatorRestNode, Tree.Kind.CLASS, JavaTree.ModifiersTreeImpl.EMPTY, this.classBody(classCreatorRestNode.getFirstChild(JavaGrammar.CLASS_BODY)));
        }
        return new JavaTree.NewClassTreeImpl(classCreatorRestNode, enclosingExpression, identifier, this.arguments(classCreatorRestNode.getFirstChild(JavaGrammar.ARGUMENTS)), classBody);
    }

    private ExpressionTree applyExplicitGenericInvocation(ExpressionTree expression, AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.EXPLICIT_GENERIC_INVOCATION);
        AstNode explicitGenericInvocationSuffixNode = astNode.getFirstChild(JavaGrammar.EXPLICIT_GENERIC_INVOCATION_SUFFIX);
        if (explicitGenericInvocationSuffixNode.hasDirectChildren(JavaGrammar.SUPER_SUFFIX)) {
            expression = new JavaTree.MemberSelectExpressionTreeImpl(astNode, (ExpressionTree)expression, this.identifier(explicitGenericInvocationSuffixNode.getFirstChild(JavaKeyword.SUPER)));
            return this.applySuperSuffix((ExpressionTree)expression, explicitGenericInvocationSuffixNode.getFirstChild(JavaGrammar.SUPER_SUFFIX));
        }
        return new JavaTree.MethodInvocationTreeImpl(astNode, (ExpressionTree)new JavaTree.MemberSelectExpressionTreeImpl(astNode, (ExpressionTree)expression, this.identifier(explicitGenericInvocationSuffixNode.getFirstChild(JavaTokenType.IDENTIFIER))), this.arguments(explicitGenericInvocationSuffixNode.getFirstChild(JavaGrammar.ARGUMENTS)));
    }

    private List<ExpressionTree> arguments(AstNode astNode) {
        JavaTreeMaker.checkType(astNode, JavaGrammar.ARGUMENTS);
        ImmutableList.Builder arguments = ImmutableList.builder();
        for (AstNode argument : astNode.getChildren(JavaGrammar.EXPRESSION)) {
            arguments.add(this.expression(argument));
        }
        return arguments.build();
    }

    private ExpressionTree applyDim(ExpressionTree expression, int count) {
        Object result = expression;
        for (int i = 0; i < count; ++i) {
            result = new JavaTree.ArrayTypeTreeImpl(null, (Tree)expression);
        }
        return result;
    }
}

