/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNodeType;
import java.util.Map;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;

public final class KindMaps {
    private final Map<JavaKeyword, Modifier> modifiers = Maps.newEnumMap(JavaKeyword.class);
    private final Map<JavaPunctuator, Tree.Kind> prefixOperators = Maps.newEnumMap(JavaPunctuator.class);
    private final Map<JavaPunctuator, Tree.Kind> postfixOperators = Maps.newEnumMap(JavaPunctuator.class);
    private final Map<JavaPunctuator, Tree.Kind> binaryOperators = Maps.newEnumMap(JavaPunctuator.class);
    private final Map<JavaPunctuator, Tree.Kind> assignmentOperators = Maps.newEnumMap(JavaPunctuator.class);
    private final Map<AstNodeType, Tree.Kind> literals;

    public KindMaps() {
        ImmutableMap.Builder<Enum, Tree.Kind> literalsBuilder = ImmutableMap.builder();
        literalsBuilder.put(JavaTokenType.INTEGER_LITERAL, Tree.Kind.INT_LITERAL);
        literalsBuilder.put(JavaTokenType.LONG_LITERAL, Tree.Kind.LONG_LITERAL);
        literalsBuilder.put(JavaTokenType.FLOAT_LITERAL, Tree.Kind.FLOAT_LITERAL);
        literalsBuilder.put(JavaTokenType.DOUBLE_LITERAL, Tree.Kind.DOUBLE_LITERAL);
        literalsBuilder.put(JavaKeyword.TRUE, Tree.Kind.BOOLEAN_LITERAL);
        literalsBuilder.put(JavaKeyword.FALSE, Tree.Kind.BOOLEAN_LITERAL);
        literalsBuilder.put(JavaTokenType.CHARACTER_LITERAL, Tree.Kind.CHAR_LITERAL);
        literalsBuilder.put(JavaTokenType.LITERAL, Tree.Kind.STRING_LITERAL);
        literalsBuilder.put(JavaKeyword.NULL, Tree.Kind.NULL_LITERAL);
        this.literals = literalsBuilder.build();
        this.modifiers.put(JavaKeyword.PUBLIC, Modifier.PUBLIC);
        this.modifiers.put(JavaKeyword.PROTECTED, Modifier.PROTECTED);
        this.modifiers.put(JavaKeyword.PRIVATE, Modifier.PRIVATE);
        this.modifiers.put(JavaKeyword.ABSTRACT, Modifier.ABSTRACT);
        this.modifiers.put(JavaKeyword.STATIC, Modifier.STATIC);
        this.modifiers.put(JavaKeyword.FINAL, Modifier.FINAL);
        this.modifiers.put(JavaKeyword.TRANSIENT, Modifier.TRANSIENT);
        this.modifiers.put(JavaKeyword.VOLATILE, Modifier.VOLATILE);
        this.modifiers.put(JavaKeyword.SYNCHRONIZED, Modifier.SYNCHRONIZED);
        this.modifiers.put(JavaKeyword.NATIVE, Modifier.NATIVE);
        this.modifiers.put(JavaKeyword.STRICTFP, Modifier.STRICTFP);
        this.prefixOperators.put(JavaPunctuator.INC, Tree.Kind.PREFIX_INCREMENT);
        this.prefixOperators.put(JavaPunctuator.DEC, Tree.Kind.PREFIX_DECREMENT);
        this.prefixOperators.put(JavaPunctuator.PLUS, Tree.Kind.UNARY_PLUS);
        this.prefixOperators.put(JavaPunctuator.MINUS, Tree.Kind.UNARY_MINUS);
        this.prefixOperators.put(JavaPunctuator.TILDA, Tree.Kind.BITWISE_COMPLEMENT);
        this.prefixOperators.put(JavaPunctuator.BANG, Tree.Kind.LOGICAL_COMPLEMENT);
        this.postfixOperators.put(JavaPunctuator.INC, Tree.Kind.POSTFIX_INCREMENT);
        this.postfixOperators.put(JavaPunctuator.DEC, Tree.Kind.POSTFIX_DECREMENT);
        this.binaryOperators.put(JavaPunctuator.STAR, Tree.Kind.MULTIPLY);
        this.binaryOperators.put(JavaPunctuator.DIV, Tree.Kind.DIVIDE);
        this.binaryOperators.put(JavaPunctuator.MOD, Tree.Kind.REMAINDER);
        this.binaryOperators.put(JavaPunctuator.PLUS, Tree.Kind.PLUS);
        this.binaryOperators.put(JavaPunctuator.MINUS, Tree.Kind.MINUS);
        this.binaryOperators.put(JavaPunctuator.SL, Tree.Kind.LEFT_SHIFT);
        this.binaryOperators.put(JavaPunctuator.SR, Tree.Kind.RIGHT_SHIFT);
        this.binaryOperators.put(JavaPunctuator.BSR, Tree.Kind.UNSIGNED_RIGHT_SHIFT);
        this.binaryOperators.put(JavaPunctuator.LT, Tree.Kind.LESS_THAN);
        this.binaryOperators.put(JavaPunctuator.GT, Tree.Kind.GREATER_THAN);
        this.binaryOperators.put(JavaPunctuator.LE, Tree.Kind.LESS_THAN_OR_EQUAL_TO);
        this.binaryOperators.put(JavaPunctuator.GE, Tree.Kind.GREATER_THAN_OR_EQUAL_TO);
        this.binaryOperators.put(JavaPunctuator.EQUAL, Tree.Kind.EQUAL_TO);
        this.binaryOperators.put(JavaPunctuator.NOTEQUAL, Tree.Kind.NOT_EQUAL_TO);
        this.binaryOperators.put(JavaPunctuator.AND, Tree.Kind.AND);
        this.binaryOperators.put(JavaPunctuator.HAT, Tree.Kind.XOR);
        this.binaryOperators.put(JavaPunctuator.OR, Tree.Kind.OR);
        this.binaryOperators.put(JavaPunctuator.ANDAND, Tree.Kind.CONDITIONAL_AND);
        this.binaryOperators.put(JavaPunctuator.OROR, Tree.Kind.CONDITIONAL_OR);
        this.assignmentOperators.put(JavaPunctuator.EQU, Tree.Kind.ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.PLUSEQU, Tree.Kind.PLUS_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.STAREQU, Tree.Kind.MULTIPLY_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.DIVEQU, Tree.Kind.DIVIDE_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.MODEQU, Tree.Kind.REMAINDER_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.PLUSEQU, Tree.Kind.PLUS_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.MINUSEQU, Tree.Kind.MINUS_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.SLEQU, Tree.Kind.LEFT_SHIFT_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.SREQU, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.BSREQU, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.ANDEQU, Tree.Kind.AND_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.HATEQU, Tree.Kind.XOR_ASSIGNMENT);
        this.assignmentOperators.put(JavaPunctuator.OREQU, Tree.Kind.OR_ASSIGNMENT);
    }

    public Modifier getModifier(JavaKeyword keyword) {
        return Preconditions.checkNotNull(this.modifiers.get(keyword), "Mapping not found for modifier %s", keyword);
    }

    public Tree.Kind getPrefixOperator(JavaPunctuator punctuator) {
        return Preconditions.checkNotNull(this.prefixOperators.get(punctuator), "Mapping not found for prefix operator %s", punctuator);
    }

    public Tree.Kind getPostfixOperator(JavaPunctuator punctuator) {
        return Preconditions.checkNotNull(this.postfixOperators.get(punctuator), "Mapping not found for postfix operator %s", punctuator);
    }

    public Tree.Kind getBinaryOperator(JavaPunctuator punctuator) {
        return Preconditions.checkNotNull(this.binaryOperators.get(punctuator), "Mapping not found for binary operator %s", punctuator);
    }

    public Tree.Kind getAssignmentOperator(JavaPunctuator punctuator) {
        return Preconditions.checkNotNull(this.assignmentOperators.get(punctuator), "Mapping not found for assignment operator %s", punctuator);
    }

    public Tree.Kind getLiteral(AstNodeType tokenType) {
        return Preconditions.checkNotNull(this.literals.get(tokenType), "Mapping not found for literal %s", tokenType);
    }
}

