/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Map;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaPunctuator;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;
import org.sonar.java.resolve.Type;

public class ExpressionVisitor
extends JavaAstVisitor {
    private final Map<AstNodeType, Type> typesOfLiterals = Maps.newHashMap();
    private final AstNodeType[] binaryOperatorAstNodeTypes;
    private final SemanticModel semanticModel;
    private final Symbols symbols;
    private final Resolve resolve;
    private final Map<AstNode, Type> types = Maps.newHashMap();

    public ExpressionVisitor(SemanticModel semanticModel, Symbols symbols, Resolve resolve) {
        this.semanticModel = semanticModel;
        this.symbols = symbols;
        this.resolve = resolve;
        this.typesOfLiterals.put(JavaKeyword.TRUE, symbols.booleanType);
        this.typesOfLiterals.put(JavaKeyword.FALSE, symbols.booleanType);
        this.typesOfLiterals.put(JavaKeyword.NULL, symbols.nullType);
        this.typesOfLiterals.put(JavaTokenType.CHARACTER_LITERAL, symbols.charType);
        this.typesOfLiterals.put(JavaTokenType.LITERAL, symbols.stringType);
        this.typesOfLiterals.put(JavaTokenType.FLOAT_LITERAL, symbols.floatType);
        this.typesOfLiterals.put(JavaTokenType.DOUBLE_LITERAL, symbols.doubleType);
        this.typesOfLiterals.put(JavaTokenType.LONG_LITERAL, symbols.longType);
        this.typesOfLiterals.put(JavaTokenType.INTEGER_LITERAL, symbols.intType);
        this.binaryOperatorAstNodeTypes = new AstNodeType[]{JavaGrammar.MULTIPLICATIVE_EXPRESSION, JavaGrammar.ADDITIVE_EXPRESSION, JavaGrammar.SHIFT_EXPRESSION, JavaGrammar.RELATIONAL_EXPRESSION, JavaGrammar.EQUALITY_EXPRESSION, JavaGrammar.AND_EXPRESSION, JavaGrammar.EXCLUSIVE_OR_EXPRESSION, JavaGrammar.INCLUSIVE_OR_EXPRESSION, JavaGrammar.CONDITIONAL_AND_EXPRESSION, JavaGrammar.CONDITIONAL_OR_EXPRESSION};
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.EXPRESSION, JavaGrammar.PRIMARY, JavaGrammar.UNARY_EXPRESSION, JavaGrammar.LITERAL, JavaGrammar.TYPE});
        this.subscribeTo(this.binaryOperatorAstNodeTypes);
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CONDITIONAL_EXPRESSION});
        this.subscribeTo(new AstNodeType[]{JavaGrammar.ASSIGNMENT_EXPRESSION});
    }

    public void leaveNode(AstNode astNode) {
        Type type;
        Resolve.Env env = this.semanticModel.getEnv(astNode);
        if (astNode.is(JavaGrammar.EXPRESSION)) {
            type = this.visitExpression(astNode);
        } else if (astNode.is(JavaGrammar.PRIMARY)) {
            type = this.visitPrimary(env, astNode);
        } else if (astNode.is(JavaGrammar.UNARY_EXPRESSION)) {
            type = this.visitUnaryExpression(env, astNode);
        } else if (astNode.is(JavaGrammar.LITERAL)) {
            type = this.visitLiteral(astNode);
        } else if (astNode.is(JavaGrammar.TYPE)) {
            type = this.visitType(env, astNode);
        } else if (astNode.is(this.binaryOperatorAstNodeTypes)) {
            type = this.visitBinaryOperation(env, astNode);
        } else if (astNode.is(JavaGrammar.CONDITIONAL_EXPRESSION)) {
            type = this.visitConditionalExpression();
        } else if (astNode.is(JavaGrammar.ASSIGNMENT_EXPRESSION)) {
            type = this.visitAssignmentExpression(astNode);
        } else {
            throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType());
        }
        this.types.put(astNode, type);
    }

    private Type visitLiteral(AstNode astNode) {
        astNode = astNode.getFirstChild();
        Type result = this.typesOfLiterals.get(astNode.getType());
        return Preconditions.checkNotNull(result, "Unexpected AstNodeType: " + astNode.getType());
    }

    private Type visitType(Resolve.Env env, AstNode astNode) {
        Type result;
        AstNode firstChildNode = astNode.getFirstChild();
        if (firstChildNode.is(JavaGrammar.BASIC_TYPE)) {
            result = this.resolve.findIdent((Resolve.Env)env, (String)firstChildNode.getFirstChild().getTokenValue(), (int)2).type;
        } else if (firstChildNode.is(JavaGrammar.CLASS_TYPE)) {
            result = this.resolveType(env, firstChildNode);
        } else {
            throw new IllegalArgumentException("Unexpected AstNodeType: " + firstChildNode.getType());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Type visitPrimary(Resolve.Env env, AstNode astNode) {
        AstNode firstChildNode = astNode.getFirstChild();
        if (firstChildNode.is(JavaGrammar.LITERAL)) {
            return this.getType(firstChildNode);
        }
        if (firstChildNode.is(JavaKeyword.THIS)) {
            if (!astNode.hasDirectChildren(JavaGrammar.ARGUMENTS)) return this.getTypeOfSymbol(this.resolve.findIdent(env, "this", 4));
            return this.symbols.unknownType;
        }
        if (firstChildNode.is(JavaKeyword.SUPER)) {
            AstNode superSuffixNode = astNode.getFirstChild(JavaGrammar.SUPER_SUFFIX);
            if (superSuffixNode.hasDirectChildren(JavaGrammar.ARGUMENTS)) {
                return this.symbols.unknownType;
            }
            Type type = this.getTypeOfSymbol(this.resolve.findIdent(env, "super", 4));
            AstNode identifierNode = superSuffixNode.getFirstChild(JavaTokenType.IDENTIFIER);
            Symbol symbol = this.resolve.findIdentInType(env, type.symbol, identifierNode.getTokenValue(), 4);
            this.associateReference(identifierNode, symbol);
            return this.getTypeOfSymbol(symbol);
        }
        if (firstChildNode.is(JavaGrammar.PAR_EXPRESSION)) {
            return this.getType(firstChildNode.getFirstChild(JavaGrammar.EXPRESSION));
        }
        if (firstChildNode.is(JavaKeyword.NEW)) {
            return this.visitCreator(env, astNode.getFirstChild(JavaGrammar.CREATOR));
        }
        if (firstChildNode.is(JavaGrammar.QUALIFIED_IDENTIFIER)) {
            AstNode identifierSuffixNode = astNode.getFirstChild(JavaGrammar.IDENTIFIER_SUFFIX);
            if (identifierSuffixNode == null) {
                return this.resolveQualifiedIdentifier(env, firstChildNode);
            }
            if (identifierSuffixNode.getFirstChild().is(JavaPunctuator.LBRK)) {
                if (!identifierSuffixNode.hasDirectChildren(JavaKeyword.CLASS)) Type type;
                return (type = this.resolveQualifiedIdentifier(env, firstChildNode)) instanceof Type.ArrayType ? ((Type.ArrayType)type).elementType : this.symbols.unknownType;
                this.resolveQualifiedIdentifier(env, firstChildNode);
                return this.symbols.classType;
            }
            if (identifierSuffixNode.getFirstChild().is(JavaGrammar.ARGUMENTS)) {
                return this.resolveMethod(env, astNode);
            }
            if (!identifierSuffixNode.getFirstChild().is(JavaPunctuator.DOT)) throw new IllegalArgumentException("Unexpected AstNodeType: " + identifierSuffixNode.getFirstChild());
            Type type = this.resolveQualifiedIdentifier(env, firstChildNode);
            if (identifierSuffixNode.hasDirectChildren(JavaKeyword.CLASS)) {
                return this.symbols.classType;
            }
            if (identifierSuffixNode.hasDirectChildren(JavaGrammar.EXPLICIT_GENERIC_INVOCATION)) {
                return this.symbols.unknownType;
            }
            if (identifierSuffixNode.hasDirectChildren(JavaKeyword.THIS)) {
                return type;
            }
            if (identifierSuffixNode.hasDirectChildren(JavaKeyword.SUPER)) {
                return this.symbols.unknownType;
            }
            if (!identifierSuffixNode.hasDirectChildren(JavaKeyword.NEW)) throw new IllegalArgumentException("Unexpected AstNodeType: " + identifierSuffixNode.getChild(1));
            return this.symbols.unknownType;
        }
        if (firstChildNode.is(JavaGrammar.BASIC_TYPE)) {
            return this.symbols.classType;
        }
        if (!firstChildNode.is(JavaKeyword.VOID)) throw new IllegalArgumentException("Unexpected AstNodeType: " + firstChildNode.getType());
        return this.symbols.classType;
    }

    private Type visitCreator(Resolve.Env env, AstNode astNode) {
        Type result;
        if (astNode.hasDirectChildren(JavaGrammar.ARRAY_CREATOR_REST)) {
            Type type = this.getType(astNode.getFirstChild(JavaGrammar.CLASS_TYPE, JavaGrammar.BASIC_TYPE));
            astNode = astNode.getFirstChild(JavaGrammar.ARRAY_CREATOR_REST);
            int dimensions = astNode.getChildren(JavaPunctuator.LBRK, JavaGrammar.DIM, JavaGrammar.DIM_EXPR).size();
            for (int i = 0; i < dimensions; ++i) {
                type = new Type.ArrayType(type, this.symbols.arrayClass);
            }
            result = type;
        } else if (astNode.hasDirectChildren(JavaGrammar.CLASS_CREATOR_REST)) {
            if (astNode.getFirstChild(JavaGrammar.CLASS_CREATOR_REST).hasDirectChildren(JavaGrammar.CLASS_BODY)) {
                result = this.symbols.unknownType;
            } else {
                astNode = astNode.getFirstChild(JavaGrammar.CREATED_NAME);
                result = this.resolveType(env, astNode);
            }
        } else {
            throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType());
        }
        return result;
    }

    private Type visitUnaryExpression(Resolve.Env env, AstNode astNode) {
        Type result;
        AstNode firstChildNode = astNode.getFirstChild();
        if (firstChildNode.is(JavaPunctuator.LPAR)) {
            result = this.getType(astNode.getFirstChild(JavaGrammar.TYPE));
        } else if (firstChildNode.is(JavaGrammar.PRIMARY)) {
            Type type = this.getType(firstChildNode);
            for (AstNode selectorNode : astNode.getChildren(JavaGrammar.SELECTOR)) {
                type = this.applySelector(env, type, selectorNode);
            }
            result = type;
        } else if (astNode.getFirstChild().is(JavaGrammar.PREFIX_OP)) {
            result = this.getType(astNode.getFirstChild().getNextSibling());
        } else {
            throw new IllegalArgumentException("Unexpected AstNodeType: " + firstChildNode.getType());
        }
        return result;
    }

    private Type applySelector(Resolve.Env env, Type type, AstNode astNode) {
        Type result;
        Preconditions.checkArgument(astNode.is(JavaGrammar.SELECTOR));
        if (type == this.symbols.unknownType || type == null) {
            return this.symbols.unknownType;
        }
        if (astNode.getFirstChild().is(JavaGrammar.DIM_EXPR)) {
            result = type instanceof Type.ArrayType ? ((Type.ArrayType)type).elementType : this.symbols.unknownType;
        } else if (astNode.hasDirectChildren(JavaTokenType.IDENTIFIER)) {
            if (astNode.hasDirectChildren(JavaGrammar.ARGUMENTS)) {
                result = this.symbols.unknownType;
            } else {
                AstNode identifierNode = astNode.getFirstChild(JavaTokenType.IDENTIFIER);
                Symbol symbol = this.resolve.findIdentInType(env, type.symbol, identifierNode.getTokenValue(), 4);
                this.associateReference(identifierNode, symbol);
                result = this.getTypeOfSymbol(symbol);
            }
        } else {
            result = this.symbols.unknownType;
        }
        return result;
    }

    private Type visitBinaryOperation(Resolve.Env env, AstNode astNode) {
        Type left = this.getType(astNode.getFirstChild());
        for (int i = 1; i < astNode.getNumberOfChildren(); i += 2) {
            AstNode opNode = astNode.getChild(i);
            if (opNode.is(JavaKeyword.INSTANCEOF)) {
                left = this.symbols.booleanType;
                continue;
            }
            Type right = this.getType(astNode.getChild(i + 1));
            if (left == null || right == null) {
                return this.symbols.unknownType;
            }
            Symbol symbol = this.resolve.findMethod(env, opNode.getTokenValue(), ImmutableList.of(left, right));
            if (symbol.kind != 16) {
                return this.symbols.unknownType;
            }
            left = ((Type.MethodType)symbol.type).resultType;
        }
        return left;
    }

    private Type visitConditionalExpression() {
        return this.symbols.unknownType;
    }

    private Type visitAssignmentExpression(AstNode astNode) {
        return this.getType(astNode.getFirstChild());
    }

    private Type visitExpression(AstNode astNode) {
        return this.getType(astNode.getFirstChild());
    }

    private Type resolveMethod(Resolve.Env env, AstNode astNode) {
        AstNode qualifiedIdentifierNode = astNode.getFirstChild(JavaGrammar.QUALIFIED_IDENTIFIER);
        Type type = qualifiedIdentifierNode.getNumberOfChildren() > 1 ? this.resolveQualifiedIdentifier(env, qualifiedIdentifierNode, true) : env.enclosingClass.type;
        if (type == null) {
            return this.symbols.unknownType;
        }
        AstNode identifierNode = qualifiedIdentifierNode.getLastChild();
        Symbol symbol = this.resolve.findMethod(env, type.symbol, identifierNode.getTokenValue(), ImmutableList.<Type>of());
        this.associateReference(identifierNode, symbol);
        return this.getTypeOfSymbol(symbol);
    }

    private Type resolveQualifiedIdentifier(Resolve.Env env, AstNode astNode) {
        return this.resolveQualifiedIdentifier(env, astNode, false);
    }

    private Type resolveQualifiedIdentifier(Resolve.Env env, AstNode astNode, boolean method) {
        Preconditions.checkArgument(astNode.is(JavaGrammar.QUALIFIED_IDENTIFIER), "Unexpected AstNodeType: " + astNode.getType());
        List<AstNode> identifiers = astNode.getChildren(JavaTokenType.IDENTIFIER);
        Symbol site = this.resolve.findIdent(env, identifiers.get(0).getTokenValue(), 7);
        this.associateReference(identifiers.get(0), site);
        for (AstNode identifierNode : identifiers.subList(1, identifiers.size() - (method ? 1 : 0))) {
            if (site.kind >= 64) {
                return this.symbols.unknownType;
            }
            String name = identifierNode.getTokenValue();
            if (site.kind == 4) {
                Type type = ((Symbol.VariableSymbol)site).type;
                if (type == null) {
                    return this.symbols.unknownType;
                }
                site = this.resolve.findIdentInType(env, type.symbol, name, 6);
            } else if (site.kind == 2) {
                site = this.resolve.findIdentInType(env, (Symbol.TypeSymbol)site, name, 6);
            } else if (site.kind == 1) {
                site = this.resolve.findIdentInPackage(env, site, name, 5);
            } else {
                throw new IllegalStateException();
            }
            this.associateReference(identifierNode, site);
        }
        return this.getTypeOfSymbol(site);
    }

    private Type resolveType(Resolve.Env env, AstNode astNode) {
        Preconditions.checkArgument(astNode.is(JavaGrammar.CLASS_TYPE, JavaGrammar.CREATED_NAME));
        env = env.dup();
        List<AstNode> identifiers = astNode.getChildren(JavaTokenType.IDENTIFIER);
        Symbol site = this.resolve.findIdent(env, identifiers.get(0).getTokenValue(), 3);
        this.associateReference(identifiers.get(0), site);
        for (AstNode identifierNode : identifiers.subList(1, identifiers.size())) {
            if (site.kind >= 64) {
                return this.symbols.unknownType;
            }
            String name = identifierNode.getTokenValue();
            if (site.kind == 1) {
                env.packge = (Symbol.PackageSymbol)site;
                site = this.resolve.findIdentInPackage(env, site, name, 3);
            } else {
                env.enclosingClass = (Symbol.TypeSymbol)site;
                site = this.resolve.findMemberType(env, (Symbol.TypeSymbol)site, name, (Symbol.TypeSymbol)site);
            }
            this.associateReference(identifierNode, site);
        }
        return this.getTypeOfSymbol(site);
    }

    private Type getTypeOfSymbol(Symbol symbol) {
        if (symbol.kind < 64) {
            return symbol.type;
        }
        return this.symbols.unknownType;
    }

    public Type getType(AstNode astNode) {
        return this.types.get(astNode);
    }

    private void associateReference(AstNode astNode, Symbol symbol) {
        if (symbol.kind < 64 && this.semanticModel.getAstNode(symbol) != null) {
            this.semanticModel.associateReference(astNode, symbol);
        }
    }
}

