/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.java.ast.api.JavaKeyword;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.MethodHelper;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Scope;
import org.sonar.java.resolve.SecondPass;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;

public class FirstPass
extends JavaAstVisitor {
    private final AstNodeType[] scopeAndSymbolAstNodeTypes;
    private final AstNodeType[] scopeAstNodeTypes;
    private final AstNodeType[] symbolAstNodeTypes;
    private final SemanticModel semanticModel;
    private final List<Symbol> uncompleted = Lists.newArrayList();
    private final SecondPass completer;
    private Resolve.Env env;

    public FirstPass(SemanticModel semanticModel, Resolve resolve) {
        this.semanticModel = semanticModel;
        this.completer = new SecondPass(semanticModel, resolve);
        this.scopeAndSymbolAstNodeTypes = new AstNodeType[]{JavaGrammar.COMPILATION_UNIT, JavaGrammar.CLASS_DECLARATION, JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION, JavaGrammar.CLASS_CREATOR_REST, JavaGrammar.ENUM_CONSTANT, JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST, JavaGrammar.ANNOTATION_METHOD_REST};
        this.scopeAstNodeTypes = new AstNodeType[]{JavaGrammar.BLOCK, JavaGrammar.FOR_STATEMENT};
        this.symbolAstNodeTypes = new AstNodeType[]{JavaGrammar.FIELD_DECLARATION, JavaGrammar.CONSTANT_DECLARATOR_REST, JavaGrammar.FORMAL_PARAMETERS_DECLS_REST, JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT, JavaGrammar.FOR_INIT, JavaGrammar.FORMAL_PARAMETER, JavaGrammar.CATCH_FORMAL_PARAMETER, JavaGrammar.RESOURCE};
    }

    public void init() {
        this.subscribeTo(this.scopeAndSymbolAstNodeTypes);
        this.subscribeTo(this.scopeAstNodeTypes);
        this.subscribeTo(this.symbolAstNodeTypes);
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(JavaGrammar.COMPILATION_UNIT)) {
            this.visitCompilationUnit(astNode);
        } else if (astNode.is(JavaGrammar.CLASS_DECLARATION, JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION)) {
            this.visitClassDeclaration(astNode);
        } else if (astNode.is(JavaGrammar.CLASS_CREATOR_REST)) {
            this.visitClassCreatorRest(astNode);
        } else if (astNode.is(JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST, JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST, JavaGrammar.ANNOTATION_METHOD_REST)) {
            this.visitMethodDeclaration(astNode);
        } else if (astNode.is(JavaGrammar.ENUM_CONSTANT)) {
            this.visitEnumConstant(astNode);
        } else if (astNode.is(JavaGrammar.FIELD_DECLARATION)) {
            this.visitFieldDeclaration(astNode);
        } else if (astNode.is(JavaGrammar.CONSTANT_DECLARATOR_REST)) {
            this.visitConstantDeclaration(astNode);
        } else if (astNode.is(JavaGrammar.FORMAL_PARAMETERS_DECLS_REST)) {
            this.visitMethodParameter(astNode);
        } else if (astNode.is(JavaGrammar.LOCAL_VARIABLE_DECLARATION_STATEMENT)) {
            this.visitLocalVariableDeclarationStatement(astNode);
        } else if (astNode.is(JavaGrammar.FOR_INIT)) {
            this.visitForInit(astNode);
        } else if (astNode.is(JavaGrammar.FORMAL_PARAMETER)) {
            this.visitForFormalParameter(astNode);
        } else if (astNode.is(JavaGrammar.CATCH_FORMAL_PARAMETER)) {
            this.visitCatchFormalParameter(astNode);
        } else if (astNode.is(JavaGrammar.RESOURCE)) {
            this.visitResource(astNode);
        } else if (astNode.is(JavaGrammar.BLOCK)) {
            this.visitBlockStatement(astNode);
        } else if (astNode.is(JavaGrammar.FOR_STATEMENT)) {
            this.visitForStatement(astNode);
        } else {
            throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType());
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(this.scopeAndSymbolAstNodeTypes)) {
            if (astNode.isNot(JavaGrammar.CLASS_CREATOR_REST, JavaGrammar.ENUM_CONSTANT) || astNode.hasDirectChildren(JavaGrammar.CLASS_BODY)) {
                this.restoreEnvironment(astNode);
            }
        } else if (astNode.is(this.scopeAstNodeTypes)) {
            this.restoreEnvironment(astNode);
        } else if (!astNode.is(this.symbolAstNodeTypes)) {
            throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType());
        }
    }

    private void restoreEnvironment(AstNode astNode) {
        if (this.env.next == null) {
            Preconditions.checkState(astNode.is(JavaGrammar.COMPILATION_UNIT));
        } else {
            this.env = this.env.next;
        }
    }

    public void leaveFile(AstNode astNode) {
        for (Symbol symbol : this.uncompleted) {
            symbol.complete();
        }
        this.uncompleted.clear();
    }

    private void visitCompilationUnit(AstNode astNode) {
        Symbol.PackageSymbol symbol = new Symbol.PackageSymbol(null, null);
        symbol.members = new Scope(symbol);
        this.env = new Resolve.Env();
        this.env.packge = symbol;
        this.env.scope = symbol.members;
        this.semanticModel.associateEnv(astNode, this.env);
    }

    private void visitClassDeclaration(AstNode astNode) {
        AstNode identifierNode = astNode.getFirstChild(JavaTokenType.IDENTIFIER);
        String name = identifierNode.getTokenValue();
        Symbol.TypeSymbol symbol = new Symbol.TypeSymbol(this.computeClassFlags(astNode), name, this.env.scope.owner);
        this.enterSymbol(identifierNode, symbol);
        symbol.members = new Scope(symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
        Resolve.Env classEnv = this.env.dup();
        classEnv.outer = this.env;
        classEnv.enclosingClass = symbol;
        classEnv.scope = symbol.members;
        this.env = classEnv;
        this.semanticModel.associateEnv(astNode, this.env);
    }

    private void visitClassCreatorRest(AstNode astNode) {
        if (astNode.hasDirectChildren(JavaGrammar.CLASS_BODY)) {
            Symbol.TypeSymbol symbol = new Symbol.TypeSymbol(0, "", this.env.scope.owner);
            symbol.members = new Scope(symbol);
            symbol.completer = this.completer;
            this.uncompleted.add(symbol);
            this.semanticModel.saveEnv(symbol, this.env);
            Resolve.Env classEnv = this.env.dup();
            classEnv.outer = this.env;
            classEnv.enclosingClass = symbol;
            classEnv.scope = symbol.members;
            this.env = classEnv;
            this.semanticModel.associateEnv(astNode.getFirstChild(JavaGrammar.CLASS_BODY), this.env);
        }
    }

    private int computeModifierFlag(AstNode astNode) {
        Preconditions.checkArgument(astNode.is(JavaGrammar.MODIFIER));
        AstNode modifierNode = astNode.getFirstChild();
        int flag = modifierNode.is(JavaKeyword.PRIVATE) ? 2 : (modifierNode.is(JavaKeyword.PROTECTED) ? 4 : (modifierNode.is(JavaKeyword.PUBLIC) ? 1 : 0));
        return flag;
    }

    private int computeFlags(AstNode astNode) {
        int flags = 0;
        for (AstNode modifierNode = astNode.getPreviousAstNode(); modifierNode != null && modifierNode.is(JavaGrammar.MODIFIER); modifierNode = modifierNode.getPreviousAstNode()) {
            flags |= this.computeModifierFlag(modifierNode);
        }
        return flags;
    }

    private int computeClassFlags(AstNode astNode) {
        int flags = this.computeFlags(astNode);
        if (astNode.is(JavaGrammar.INTERFACE_DECLARATION)) {
            flags |= 0x200;
        } else if (astNode.is(JavaGrammar.ENUM_DECLARATION)) {
            flags |= 0x4000;
        } else if (astNode.is(JavaGrammar.ANNOTATION_TYPE_DECLARATION)) {
            flags |= 0x2200;
        }
        if (this.env.scope.owner instanceof Symbol.TypeSymbol && (this.env.enclosingClass.flags() & 0x200) != 0) {
            flags |= 1;
        }
        return flags;
    }

    private void visitMethodDeclaration(AstNode astNode) {
        MethodHelper methodHelper = new MethodHelper(astNode);
        AstNode identifierNode = methodHelper.getName();
        String name = methodHelper.isConstructor() ? "<init>" : identifierNode.getTokenValue();
        Symbol.MethodSymbol symbol = new Symbol.MethodSymbol(this.computeMethodFlags(astNode), name, this.env.scope.owner);
        this.enterSymbol(identifierNode, symbol);
        symbol.parameters = new Scope(symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
        Resolve.Env methodEnv = this.env.dup();
        methodEnv.scope = symbol.parameters;
        this.env = methodEnv;
    }

    private int computeMethodFlags(AstNode astNode) {
        if (astNode.is(JavaGrammar.METHOD_DECLARATOR_REST, JavaGrammar.VOID_METHOD_DECLARATOR_REST, JavaGrammar.CONSTRUCTOR_DECLARATOR_REST)) {
            return this.computeFlags(astNode.getFirstAncestor(JavaGrammar.MEMBER_DECL));
        }
        if (astNode.is(JavaGrammar.INTERFACE_METHOD_DECLARATOR_REST, JavaGrammar.VOID_INTERFACE_METHOD_DECLARATORS_REST)) {
            return 1;
        }
        if (astNode.is(JavaGrammar.ANNOTATION_METHOD_REST)) {
            return 1;
        }
        throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType());
    }

    private void visitEnumConstant(AstNode astNode) {
        this.declareVariable(16385, astNode.getFirstChild(JavaTokenType.IDENTIFIER));
        if (astNode.hasDirectChildren(JavaGrammar.CLASS_BODY)) {
            this.visitClassCreatorRest(astNode);
        }
    }

    private void visitFieldDeclaration(AstNode astNode) {
        int flags = this.computeFlags(astNode);
        for (AstNode variableDeclaratorNode : astNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATORS).getChildren(JavaGrammar.VARIABLE_DECLARATOR)) {
            this.declareVariable(flags, variableDeclaratorNode.getFirstChild(JavaTokenType.IDENTIFIER));
        }
    }

    private void visitConstantDeclaration(AstNode astNode) {
        this.declareVariable(1, astNode.getPreviousAstNode());
    }

    private void visitMethodParameter(AstNode astNode) {
        this.declareVariable(0, astNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATOR_ID).getFirstChild(JavaTokenType.IDENTIFIER));
    }

    private void visitLocalVariableDeclarationStatement(AstNode astNode) {
        for (AstNode variableDeclaratorNode : astNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATORS).getChildren(JavaGrammar.VARIABLE_DECLARATOR)) {
            this.declareVariable(0, variableDeclaratorNode.getFirstChild(JavaTokenType.IDENTIFIER));
        }
    }

    private void visitForInit(AstNode astNode) {
        if (astNode.hasDirectChildren(JavaGrammar.VARIABLE_DECLARATORS)) {
            for (AstNode variableDeclaratorNode : astNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATORS).getChildren(JavaGrammar.VARIABLE_DECLARATOR)) {
                this.declareVariable(0, variableDeclaratorNode.getFirstChild(JavaTokenType.IDENTIFIER));
            }
        }
    }

    private void visitForFormalParameter(AstNode astNode) {
        this.declareVariable(0, astNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATOR_ID).getFirstChild(JavaTokenType.IDENTIFIER));
    }

    private void visitCatchFormalParameter(AstNode astNode) {
        this.declareVariable(0, astNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATOR_ID).getFirstChild(JavaTokenType.IDENTIFIER));
    }

    private void visitResource(AstNode astNode) {
        this.declareVariable(0, astNode.getFirstChild(JavaGrammar.VARIABLE_DECLARATOR_ID).getFirstChild(JavaTokenType.IDENTIFIER));
    }

    private void declareVariable(int flags, AstNode identifierNode) {
        Preconditions.checkArgument(identifierNode.is(JavaTokenType.IDENTIFIER));
        String name = identifierNode.getTokenValue();
        Symbol.VariableSymbol symbol = new Symbol.VariableSymbol(flags, name, this.env.scope.owner);
        this.enterSymbol(identifierNode, symbol);
        symbol.completer = this.completer;
        this.uncompleted.add(symbol);
        this.semanticModel.saveEnv(symbol, this.env);
    }

    private void visitBlockStatement(AstNode astNode) {
        Scope scope = new Scope(this.env.scope);
        Resolve.Env blockEnv = this.env.dup();
        blockEnv.scope = scope;
        this.env = blockEnv;
        this.semanticModel.associateEnv(astNode, this.env);
    }

    private void visitForStatement(AstNode astNode) {
        Scope scope = new Scope(this.env.scope);
        Resolve.Env forEnv = this.env.dup();
        forEnv.scope = scope;
        this.env = forEnv;
        this.semanticModel.associateEnv(astNode, this.env);
    }

    private void enterSymbol(AstNode astNode, Symbol symbol) {
        this.env.scope.enter(symbol);
        this.semanticModel.associateSymbol(astNode, symbol);
    }
}

