/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;

public class LabelsVisitor
extends JavaAstVisitor {
    private final SemanticModel semanticModel;

    public LabelsVisitor(SemanticModel semanticModel) {
        this.semanticModel = semanticModel;
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.LABELED_STATEMENT, JavaGrammar.BREAK_STATEMENT, JavaGrammar.CONTINUE_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(JavaGrammar.LABELED_STATEMENT)) {
            this.visitLabeledStatement(astNode);
        } else if (astNode.is(JavaGrammar.BREAK_STATEMENT, JavaGrammar.CONTINUE_STATEMENT)) {
            this.visitBreakOrContinueStatement(astNode);
        } else {
            throw new IllegalArgumentException("Unexpected AstNodeType: " + astNode.getType());
        }
    }

    private void visitLabeledStatement(AstNode astNode) {
        AstNode identifierNode = astNode.getFirstChild(JavaTokenType.IDENTIFIER);
        this.semanticModel.associateSymbol(identifierNode, new Symbol(0, 0, identifierNode.getTokenValue(), null));
    }

    private void visitBreakOrContinueStatement(AstNode astNode) {
        AstNode identifier = astNode.getFirstChild(JavaTokenType.IDENTIFIER);
        if (identifier != null) {
            AstNode labelledStatement;
            String label = identifier.getTokenValue();
            for (labelledStatement = astNode.getFirstAncestor(JavaGrammar.LABELED_STATEMENT); labelledStatement != null && !label.equals(labelledStatement.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue()); labelledStatement = labelledStatement.getFirstAncestor(JavaGrammar.LABELED_STATEMENT)) {
            }
            if (labelledStatement != null) {
                this.semanticModel.associateReference(identifier, this.semanticModel.getSymbol(labelledStatement.getFirstChild(JavaTokenType.IDENTIFIER)));
            }
        }
    }
}

