/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstVisitor;
import com.sonar.sslr.impl.ast.AstWalker;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.resolve.ExpressionVisitor;
import org.sonar.java.resolve.FirstPass;
import org.sonar.java.resolve.LabelsVisitor;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Symbols;

public class SemanticModel {
    private final BiMap<AstNode, Symbol> symbols = HashBiMap.create();
    private final Multimap<Symbol, AstNode> usages = HashMultimap.create();
    private final Map<Symbol, Resolve.Env> symbolEnvs = Maps.newHashMap();
    private final Map<AstNode, Resolve.Env> envs = Maps.newHashMap();

    public static SemanticModel createFor(AstNode astNode) {
        SemanticModel semanticModel = new SemanticModel();
        Resolve resolve = new Resolve();
        Symbols symbols = new Symbols();
        SemanticModel.visit(astNode, new FirstPass(semanticModel, resolve));
        SemanticModel.visit(astNode, new ExpressionVisitor(semanticModel, symbols, resolve), new LabelsVisitor(semanticModel));
        return semanticModel;
    }

    @VisibleForTesting
    SemanticModel() {
    }

    private static void visit(AstNode astNode, JavaAstVisitor ... visitors) {
        AstWalker astWalker = new AstWalker(new AstVisitor[0]);
        for (JavaAstVisitor visitor : visitors) {
            visitor.init();
            astWalker.addVisitor((AstVisitor)((Object)visitor));
        }
        astWalker.walkAndVisit(astNode);
    }

    public void saveEnv(Symbol symbol, Resolve.Env env) {
        this.symbolEnvs.put(symbol, env);
    }

    public Resolve.Env getEnv(Symbol symbol) {
        return this.symbolEnvs.get(symbol);
    }

    public void associateEnv(AstNode astNode, Resolve.Env env) {
        this.envs.put(astNode, env);
    }

    public Resolve.Env getEnv(AstNode astNode) {
        Resolve.Env result = null;
        while (result == null && astNode != null) {
            result = this.envs.get(astNode);
            astNode = astNode.getParent();
        }
        return result;
    }

    public void associateSymbol(AstNode astNode, Symbol symbol) {
        Preconditions.checkArgument(astNode.is(JavaTokenType.IDENTIFIER), "Expected AST node with identifier, got: %s", astNode);
        Preconditions.checkNotNull(symbol);
        this.symbols.put(astNode, symbol);
    }

    public Symbol getSymbol(AstNode astNode) {
        Preconditions.checkArgument(astNode.is(JavaTokenType.IDENTIFIER), "Expected AST node with identifier, got: %s", astNode);
        return (Symbol)this.symbols.get(astNode);
    }

    public AstNode getAstNode(Symbol symbol) {
        return (AstNode)this.symbols.inverse().get(symbol);
    }

    public void associateReference(AstNode astNode, Symbol symbol) {
        Preconditions.checkArgument(astNode.is(JavaTokenType.IDENTIFIER), "Expected AST node with identifier, got: %s", astNode);
        Preconditions.checkNotNull(symbol);
        this.usages.put(symbol, astNode);
    }

    public Map<AstNode, Symbol> getSymbols() {
        return Collections.unmodifiableMap(this.symbols);
    }

    public Collection<AstNode> getUsages(Symbol symbol) {
        return Collections.unmodifiableCollection(this.usages.get(symbol));
    }
}

