/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.ast.select;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.sslr.ast.AstSelect;
import org.sonar.sslr.internal.ast.select.AstSelectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAstSelect
implements AstSelect {
    private final List<AstNode> list;

    public ListAstSelect(List<AstNode> list) {
        this.list = list;
    }

    @Override
    public AstSelect children() {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            result.addAll(node.getChildren());
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect children(AstNodeType type) {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            for (AstNode child : node.getChildren()) {
                if (child.getType() != type) continue;
                result.add(child);
            }
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect children(AstNodeType ... types) {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            for (AstNode child : node.getChildren()) {
                if (!child.is(types)) continue;
                result.add(child);
            }
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect nextSibling() {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            if ((node = node.getNextSibling()) == null) continue;
            result.add(node);
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect previousSibling() {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            if ((node = node.getPreviousSibling()) == null) continue;
            result.add(node);
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect parent() {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            if ((node = node.getParent()) == null) continue;
            result.add(node);
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect firstAncestor(AstNodeType type) {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            for (node = node.getParent(); node != null && node.getType() != type; node = node.getParent()) {
            }
            if (node == null) continue;
            result.add(node);
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect firstAncestor(AstNodeType ... types) {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            for (node = node.getParent(); node != null && !node.is(types); node = node.getParent()) {
            }
            if (node == null) continue;
            result.add(node);
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect descendants(AstNodeType type) {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            result.addAll(node.getDescendants(type));
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect descendants(AstNodeType ... types) {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            result.addAll(node.getDescendants(types));
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isNotEmpty() {
        return true;
    }

    @Override
    public AstSelect filter(AstNodeType type) {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            if (node.getType() != type) continue;
            result.add(node);
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect filter(AstNodeType ... types) {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            if (!node.is(types)) continue;
            result.add(node);
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public AstSelect filter(Predicate<AstNode> predicate) {
        ArrayList<AstNode> result = Lists.newArrayList();
        for (AstNode node : this.list) {
            if (!predicate.apply(node)) continue;
            result.add(node);
        }
        return AstSelectFactory.create(result);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public AstNode get(int index) {
        return this.list.get(index);
    }

    @Override
    public Iterator<AstNode> iterator() {
        return this.list.iterator();
    }
}

