/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.text;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.sonar.sslr.internal.text.PlainText;
import org.sonar.sslr.internal.text.TextUtils;
import org.sonar.sslr.text.TextLocation;

public class LocatedText
extends PlainText {
    private final File file;
    private final URI uri;
    private final int[] lines;

    public LocatedText(@Nullable File file, char[] chars) {
        super(chars);
        this.file = file;
        this.uri = file == null ? null : file.toURI();
        this.lines = TextUtils.computeLines(chars);
    }

    public TextLocation getLocation(int index) {
        Preconditions.checkPositionIndex(index, this.length());
        int line = this.getLineNumber(index);
        int column = index - this.getLineStart(line) + 1;
        return new TextLocation(this.file, this.uri, line, column);
    }

    private int getLineNumber(int index) {
        int i = Arrays.binarySearch(this.lines, index);
        return i >= 0 ? i + 2 : -i;
    }

    private int getLineStart(int line) {
        return line == 1 ? 0 : this.lines[line - 2];
    }
}

