/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.text;

import org.sonar.sslr.internal.text.AbstractText;
import org.sonar.sslr.text.Text;
import org.sonar.sslr.text.TextCharSequence;
import org.sonar.sslr.text.TextLocation;

public class SubText
extends AbstractText {
    private final AbstractText text;
    private final int start;
    private final int length;

    public SubText(AbstractText text, int start, int end) {
        this.text = text;
        this.start = start;
        this.length = end - start;
    }

    public int length() {
        return this.length;
    }

    public void toCharArray(int srcPos, char[] dest, int destPos, int length) {
        this.text.toCharArray(this.getOriginalIndex(srcPos), dest, destPos, length);
    }

    protected int getTransformationDepth() {
        return this.text.getTransformationDepth();
    }

    public TextCharSequence sequence() {
        return new SubTextCharSequence();
    }

    private int getOriginalIndex(int index) {
        return this.start + index;
    }

    private class SubTextCharSequence
    implements TextCharSequence {
        private TextCharSequence innerCursor;

        private SubTextCharSequence() {
            this.innerCursor = SubText.this.text.sequence();
        }

        public Text getText() {
            return SubText.this;
        }

        public int length() {
            return SubText.this.length;
        }

        public char charAt(int index) {
            return this.innerCursor.charAt(SubText.this.getOriginalIndex(index));
        }

        public TextCharSequence subSequence(int start, int end) {
            return this.subText(start, end).sequence();
        }

        public Text subText(int start, int end) {
            if (start == 0 && end == SubText.this.length) {
                return SubText.this;
            }
            return this.innerCursor.subText(SubText.this.getOriginalIndex(start), SubText.this.getOriginalIndex(end));
        }

        public TextLocation getLocation(int index) {
            return this.innerCursor.getLocation(SubText.this.getOriginalIndex(index));
        }

        public String toString() {
            return this.getText().toString();
        }
    }
}

