/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.sslr.internal.matchers.MatcherPathElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorTreeNode {
    public MatcherPathElement pathElement;
    public List<ErrorTreeNode> children = Lists.newArrayList();

    public static ErrorTreeNode buildTree(List<List<MatcherPathElement>> paths) {
        ErrorTreeNode root = new ErrorTreeNode();
        root.pathElement = paths.get(0).get(0);
        for (List<MatcherPathElement> path : paths) {
            ErrorTreeNode.addToTree(root, path);
        }
        return root;
    }

    private static void addToTree(ErrorTreeNode root, List<MatcherPathElement> path) {
        ErrorTreeNode current = root;
        int i = 1;
        boolean found = true;
        block0: while (found && i < path.size()) {
            found = false;
            for (ErrorTreeNode child : current.children) {
                if (!child.pathElement.equals(path.get(i))) continue;
                current = child;
                ++i;
                found = true;
                continue block0;
            }
        }
        while (i < path.size()) {
            ErrorTreeNode child = new ErrorTreeNode();
            child.pathElement = path.get(i);
            current.children.add(child);
            current = child;
            ++i;
        }
    }
}

