/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.internal.vm.CompilableGrammarRule;
import org.sonar.sslr.internal.vm.CompilationHandler;
import org.sonar.sslr.internal.vm.CompiledGrammar;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.ParsingExpression;
import org.sonar.sslr.internal.vm.RuleRefExpression;

public class MutableGrammarCompiler
extends CompilationHandler {
    private final Queue<CompilableGrammarRule> compilationQueue = Lists.newLinkedList();
    private final Map<GrammarRuleKey, CompilableGrammarRule> matchers = Maps.newHashMap();
    private final Map<GrammarRuleKey, Integer> offsets = Maps.newHashMap();

    public static CompiledGrammar compile(CompilableGrammarRule rule) {
        return new MutableGrammarCompiler().doCompile(rule);
    }

    private CompiledGrammar doCompile(CompilableGrammarRule start) {
        ArrayList<Instruction> instructions = Lists.newArrayList();
        this.compilationQueue.add(start);
        this.matchers.put(start.getRuleKey(), start);
        while (!this.compilationQueue.isEmpty()) {
            CompilableGrammarRule rule = this.compilationQueue.poll();
            GrammarRuleKey ruleKey = rule.getRuleKey();
            this.offsets.put(ruleKey, instructions.size());
            Instruction.addAll(instructions, this.compile(rule.getExpression()));
            instructions.add(Instruction.ret());
        }
        Instruction[] result = instructions.toArray(new Instruction[instructions.size()]);
        for (int i = 0; i < result.length; ++i) {
            Instruction instruction = result[i];
            if (!(instruction instanceof RuleRefExpression)) continue;
            RuleRefExpression expression = (RuleRefExpression)instruction;
            GrammarRuleKey ruleKey = expression.getRuleKey();
            int offset = this.offsets.get(ruleKey);
            result[i] = Instruction.call(offset - i, this.matchers.get(ruleKey));
        }
        return new CompiledGrammar(result, this.matchers, start.getRuleKey(), this.offsets.get(start.getRuleKey()));
    }

    public Instruction[] compile(ParsingExpression expression) {
        if (expression instanceof CompilableGrammarRule) {
            CompilableGrammarRule rule = (CompilableGrammarRule)expression;
            if (!this.matchers.containsKey(rule.getRuleKey())) {
                this.compilationQueue.add(rule);
                this.matchers.put(rule.getRuleKey(), rule);
            }
            return rule.compile(this);
        }
        return expression.compile(this);
    }
}

