/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.internal.vm;

import org.sonar.sslr.internal.vm.CompilationHandler;
import org.sonar.sslr.internal.vm.Instruction;
import org.sonar.sslr.internal.vm.ParsingExpression;

public class OptionalExpression
implements ParsingExpression {
    private final ParsingExpression subExpression;

    public OptionalExpression(ParsingExpression subExpression) {
        this.subExpression = subExpression;
    }

    public Instruction[] compile(CompilationHandler compiler) {
        Instruction[] instr = compiler.compile(this.subExpression);
        Instruction[] result = new Instruction[instr.length + 2];
        result[0] = Instruction.choice(result.length);
        System.arraycopy(instr, 0, result, 1, instr.length);
        result[instr.length + 1] = Instruction.commit(1);
        return result;
    }

    public String toString() {
        return "Optional[" + this.subExpression + "]";
    }
}

