/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.toolkit;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.sonar.sslr.api.Grammar;
import com.sonar.sslr.impl.Parser;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.sonar.colorizer.Tokenizer;
import org.sonar.sslr.internal.toolkit.SourceCodeModel;
import org.sonar.sslr.internal.toolkit.ToolkitPresenter;
import org.sonar.sslr.internal.toolkit.ToolkitViewImpl;
import org.sonar.sslr.toolkit.AbstractConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationModel;
import org.sonar.sslr.toolkit.ConfigurationProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Toolkit {
    private final String title;
    private final ConfigurationModel configurationModel;

    @Deprecated
    public Toolkit(final Parser<?> parser, final List<Tokenizer> tokenizers, String title) {
        this(title, new AbstractConfigurationModel(){

            @Override
            public List<ConfigurationProperty> getProperties() {
                return Collections.EMPTY_LIST;
            }

            @Override
            public List<Tokenizer> doGetTokenizers() {
                return tokenizers;
            }

            @Override
            public Parser<? extends Grammar> doGetParser() {
                return parser;
            }
        });
    }

    public Toolkit(String title, ConfigurationModel configurationModel) {
        Preconditions.checkNotNull(title);
        this.title = title;
        this.configurationModel = configurationModel;
    }

    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                catch (Exception e) {
                    Throwables.propagate(e);
                }
                SourceCodeModel model = new SourceCodeModel(Toolkit.this.configurationModel);
                ToolkitPresenter presenter = new ToolkitPresenter(Toolkit.this.configurationModel, model);
                presenter.setView(new ToolkitViewImpl(presenter));
                presenter.run(Toolkit.this.title);
            }
        });
    }
}

