/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import javax.annotation.Nullable;
import org.sonar.api.BatchExtension;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.source.Highlightable;
import org.sonar.api.source.Symbolizable;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannersFactory;

public class SonarComponents
implements BatchExtension {
    private final FileLinesContextFactory fileLinesContextFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final JavaFileScannersFactory[] fileScannersFactories;
    private final Project project;

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, Project project) {
        this(fileLinesContextFactory, resourcePerspectives, project, null);
    }

    public SonarComponents(FileLinesContextFactory fileLinesContextFactory, ResourcePerspectives resourcePerspectives, Project project, @Nullable JavaFileScannersFactory[] fileScannersFactories) {
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.resourcePerspectives = resourcePerspectives;
        this.project = project;
        this.fileScannersFactories = fileScannersFactories;
    }

    public Iterable<JavaFileScanner> createJavaFileScanners() {
        Iterable<JavaFileScanner> result = ImmutableList.of();
        if (this.fileScannersFactories != null) {
            for (JavaFileScannersFactory factory : this.fileScannersFactories) {
                result = Iterables.concat(result, factory.createJavaFileScanners());
            }
        }
        return result;
    }

    public Resource resourceFromIOFile(File file) {
        return org.sonar.api.resources.File.fromIOFile((File)file, (Project)this.project);
    }

    public FileLinesContext fileLinesContextFor(File file) {
        return this.fileLinesContextFactory.createFor(this.resourceFromIOFile(file));
    }

    public Symbolizable symbolizableFor(File file) {
        return (Symbolizable)this.resourcePerspectives.as(Symbolizable.class, this.resourceFromIOFile(file));
    }

    public Highlightable highlightableFor(File file) {
        return (Highlightable)this.resourcePerspectives.as(Highlightable.class, this.resourceFromIOFile(file));
    }
}

