/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitors;

import com.google.common.base.Preconditions;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.java.ast.api.JavaMetric;
import org.sonar.java.ast.api.JavaTokenType;
import org.sonar.java.ast.parser.JavaGrammar;
import org.sonar.java.ast.visitors.JavaAstVisitor;
import org.sonar.java.ast.visitors.SuppressWarningsAnnotationUtils;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.measures.MetricDef;

public class ClassVisitor
extends JavaAstVisitor {
    public void init() {
        this.subscribeTo(new AstNodeType[]{JavaGrammar.CLASS_DECLARATION, JavaGrammar.INTERFACE_DECLARATION, JavaGrammar.ENUM_DECLARATION, JavaGrammar.ANNOTATION_TYPE_DECLARATION});
    }

    public void visitNode(AstNode astNode) {
        String className = astNode.getFirstChild(JavaTokenType.IDENTIFIER).getTokenValue();
        SourceClass sourceClass = this.getContext().peekSourceCode().isType(SourceClass.class) ? ClassVisitor.createSourceClass((SourceClass)this.getContext().peekSourceCode(), className) : ClassVisitor.createSourceClass(this.peekParentPackage(), className);
        sourceClass.setStartAtLine(astNode.getTokenLine());
        sourceClass.setMeasure((MetricDef)JavaMetric.CLASSES, 1);
        sourceClass.setSuppressWarnings(SuppressWarningsAnnotationUtils.isSuppressAllWarnings(astNode));
        this.getContext().addSourceCode((SourceCode)sourceClass);
    }

    public void leaveNode(AstNode astNode) {
        Preconditions.checkState(this.getContext().peekSourceCode().isType(SourceClass.class));
        this.getContext().popSourceCode();
    }

    static SourceClass createSourceClass(SourcePackage parentPackage, String className) {
        StringBuilder key = new StringBuilder();
        if (parentPackage != null && !"".equals(parentPackage.getKey())) {
            key.append(parentPackage.getKey());
            key.append("/");
        }
        key.append(className);
        return new SourceClass(key.toString(), className);
    }

    static SourceClass createSourceClass(SourceClass parentClass, String innerClassName) {
        return new SourceClass(parentClass.getKey() + "$" + innerClassName, innerClassName);
    }
}

