/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.AssertStatementTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.BreakStatementTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ContinueStatementTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.EmptyStatementTree;
import org.sonar.plugins.java.api.tree.EnumConstantTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.ImportTree;
import org.sonar.plugins.java.api.tree.InstanceOfTree;
import org.sonar.plugins.java.api.tree.LabeledStatementTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.UnionTypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.plugins.java.api.tree.WildcardTree;

public abstract class JavaTree
implements Tree {
    private final AstNode astNode;

    public JavaTree(AstNode astNode) {
        this.astNode = astNode;
    }

    public AstNode getAstNode() {
        return this.astNode;
    }

    public int getLine() {
        return this.astNode.getTokenLine();
    }

    public final boolean is(Tree.Kind kind) {
        return this.getKind() == null ? false : this.getKind() == kind;
    }

    public abstract Tree.Kind getKind();

    public static class NotImplementedTreeImpl
    extends JavaTree
    implements ExpressionTree {
        private String name;

        public NotImplementedTreeImpl(AstNode astNode, String name) {
            super(astNode);
            this.name = name;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.OTHER;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitOther((Tree)this);
        }

        public String getName() {
            return this.name;
        }
    }

    public static class LambdaExpressionTreeImpl
    extends JavaTree
    implements LambdaExpressionTree {
        private final List<VariableTree> parameters;
        private final Tree body;

        public LambdaExpressionTreeImpl(AstNode astNode, List<VariableTree> parameters, Tree body) {
            super(astNode);
            this.parameters = parameters;
            this.body = body;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.LAMBDA_EXPRESSION;
        }

        public List<VariableTree> parameters() {
            return this.parameters;
        }

        public Tree body() {
            return this.body;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitLambdaExpression((LambdaExpressionTree)this);
        }
    }

    public static class AnnotationTreeImpl
    extends JavaTree
    implements AnnotationTree {
        private final List<ExpressionTree> arguments;
        private final Tree annotationType;

        public AnnotationTreeImpl(AstNode astNode, Tree annotationType, List<ExpressionTree> arguments) {
            super(astNode);
            this.annotationType = annotationType;
            this.arguments = arguments;
        }

        public Tree annotationType() {
            return this.annotationType;
        }

        public List<ExpressionTree> arguments() {
            return this.arguments;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ANNOTATION;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitAnnotation((AnnotationTree)this);
        }
    }

    public static class ModifiersTreeImpl
    extends JavaTree
    implements ModifiersTree {
        public static final ModifiersTreeImpl EMPTY = new ModifiersTreeImpl(null, ImmutableList.<Modifier>of(), ImmutableList.<AnnotationTree>of());
        private final List<Modifier> modifiers;
        private final List<AnnotationTree> annotations;

        public ModifiersTreeImpl(AstNode astNode, List<Modifier> modifiers, List<AnnotationTree> annotations) {
            super(astNode);
            this.modifiers = Preconditions.checkNotNull(modifiers);
            this.annotations = Preconditions.checkNotNull(annotations);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.MODIFIERS;
        }

        public List<Modifier> modifiers() {
            return this.modifiers;
        }

        public List<AnnotationTree> annotations() {
            return this.annotations;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitModifier((ModifiersTree)this);
        }
    }

    public static class UnionTypeTreeImpl
    extends JavaTree
    implements UnionTypeTree {
        private final List<Tree> typeAlternatives;

        public UnionTypeTreeImpl(AstNode astNode, List<Tree> typeAlternatives) {
            super(astNode);
            this.typeAlternatives = Preconditions.checkNotNull(typeAlternatives);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.UNION_TYPE;
        }

        public List<Tree> typeAlternatives() {
            return this.typeAlternatives;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitUnionType((UnionTypeTree)this);
        }
    }

    public static class ParameterizedTypeTreeImpl
    extends JavaTree
    implements ParameterizedTypeTree,
    ExpressionTree {
        private final ExpressionTree type;
        private final List<Tree> typeArguments;

        public ParameterizedTypeTreeImpl(AstNode child, ExpressionTree type, List<Tree> typeArguments) {
            super(child);
            this.type = Preconditions.checkNotNull(type);
            this.typeArguments = Preconditions.checkNotNull(typeArguments);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PARAMETERIZED_TYPE;
        }

        public Tree type() {
            return this.type;
        }

        public List<Tree> typeArguments() {
            return this.typeArguments;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitParameterizedType((ParameterizedTypeTree)this);
        }
    }

    public static class WildcardTreeImpl
    extends JavaTree
    implements WildcardTree {
        private final Tree.Kind kind;
        @Nullable
        private final Tree bound;

        public WildcardTreeImpl(AstNode astNode, Tree.Kind kind, @Nullable Tree bound) {
            super(astNode);
            this.kind = Preconditions.checkNotNull(kind);
            this.bound = bound;
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        @Nullable
        public Tree bound() {
            return this.bound;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitWildcard((WildcardTree)this);
        }
    }

    public static class ArrayTypeTreeImpl
    extends JavaTree
    implements ArrayTypeTree {
        private final Tree type;

        public ArrayTypeTreeImpl(AstNode astNode, Tree type) {
            super(astNode);
            this.type = Preconditions.checkNotNull(type);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ARRAY_TYPE;
        }

        public Tree type() {
            return this.type;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitArrayType((ArrayTypeTree)this);
        }
    }

    public static class ArrayAccessExpressionTreeImpl
    extends JavaTree
    implements ArrayAccessExpressionTree {
        private final ExpressionTree expression;
        private final ExpressionTree index;

        public ArrayAccessExpressionTreeImpl(AstNode astNode, ExpressionTree expression, ExpressionTree index) {
            super(astNode);
            this.expression = Preconditions.checkNotNull(expression);
            this.index = Preconditions.checkNotNull(index);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ARRAY_ACCESS_EXPRESSION;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public ExpressionTree index() {
            return this.index;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitArrayAccessExpression((ArrayAccessExpressionTree)this);
        }
    }

    public static class MemberSelectExpressionTreeImpl
    extends JavaTree
    implements MemberSelectExpressionTree {
        private final ExpressionTree expression;
        private final IdentifierTree identifier;

        public MemberSelectExpressionTreeImpl(AstNode astNode, ExpressionTree expression, IdentifierTree identifier) {
            super(astNode);
            this.expression = Preconditions.checkNotNull(expression);
            this.identifier = Preconditions.checkNotNull(identifier);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.MEMBER_SELECT;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public IdentifierTree identifier() {
            return this.identifier;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitMemberSelectExpression((MemberSelectExpressionTree)this);
        }
    }

    public static class NewClassTreeImpl
    extends JavaTree
    implements NewClassTree {
        private final ExpressionTree enclosingExpression;
        private final ExpressionTree identifier;
        private final List<ExpressionTree> arguments;
        @Nullable
        private final ClassTree classBody;

        public NewClassTreeImpl(AstNode astNode, @Nullable ExpressionTree enclosingExpression, ExpressionTree identifier, List<ExpressionTree> arguments, @Nullable ClassTree classBody) {
            super(astNode);
            this.enclosingExpression = enclosingExpression;
            this.identifier = Preconditions.checkNotNull(identifier);
            this.arguments = Preconditions.checkNotNull(arguments);
            this.classBody = classBody;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.NEW_CLASS;
        }

        @Nullable
        public ExpressionTree enclosingExpression() {
            return this.enclosingExpression;
        }

        public List<Tree> typeArguments() {
            return ImmutableList.of();
        }

        public Tree identifier() {
            return this.identifier;
        }

        public List<ExpressionTree> arguments() {
            return this.arguments;
        }

        @Nullable
        public ClassTree classBody() {
            return this.classBody;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitNewClass((NewClassTree)this);
        }
    }

    public static class NewArrayTreeImpl
    extends JavaTree
    implements NewArrayTree {
        private final Tree type;
        private final List<ExpressionTree> dimensions;
        private final List<ExpressionTree> initializers;

        public NewArrayTreeImpl(AstNode astNode, Tree type, List<ExpressionTree> dimensions, List<ExpressionTree> initializers) {
            super(astNode);
            this.type = type;
            this.dimensions = Preconditions.checkNotNull(dimensions);
            this.initializers = Preconditions.checkNotNull(initializers);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.NEW_ARRAY;
        }

        public Tree type() {
            return this.type;
        }

        public List<ExpressionTree> dimensions() {
            return this.dimensions;
        }

        public List<ExpressionTree> initializers() {
            return this.initializers;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitNewArray((NewArrayTree)this);
        }
    }

    public static class MethodInvocationTreeImpl
    extends JavaTree
    implements MethodInvocationTree {
        private final ExpressionTree methodSelect;
        private final List<ExpressionTree> arguments;

        public MethodInvocationTreeImpl(AstNode astNode, ExpressionTree methodSelect, List<ExpressionTree> arguments) {
            super(astNode);
            this.methodSelect = Preconditions.checkNotNull(methodSelect);
            this.arguments = Preconditions.checkNotNull(arguments);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.METHOD_INVOCATION;
        }

        public List<Tree> typeArguments() {
            return ImmutableList.of();
        }

        public ExpressionTree methodSelect() {
            return this.methodSelect;
        }

        public List<ExpressionTree> arguments() {
            return this.arguments;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitMethodInvocation((MethodInvocationTree)this);
        }
    }

    public static class AssignmentExpressionTreeImpl
    extends JavaTree
    implements AssignmentExpressionTree {
        private final ExpressionTree variable;
        private final Tree.Kind kind;
        private final ExpressionTree expression;

        public AssignmentExpressionTreeImpl(AstNode astNode, ExpressionTree variable, Tree.Kind kind, ExpressionTree expression) {
            super(astNode);
            this.variable = Preconditions.checkNotNull(variable);
            this.kind = Preconditions.checkNotNull(kind);
            this.expression = Preconditions.checkNotNull(expression);
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        public ExpressionTree variable() {
            return this.variable;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitAssignmentExpression((AssignmentExpressionTree)this);
        }
    }

    public static class TypeCastExpressionTreeImpl
    extends JavaTree
    implements TypeCastTree {
        private final Tree type;
        private final ExpressionTree expression;

        public TypeCastExpressionTreeImpl(AstNode astNode, Tree type, ExpressionTree expression) {
            super(astNode);
            this.type = Preconditions.checkNotNull(type);
            this.expression = Preconditions.checkNotNull(expression);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.TYPE_CAST;
        }

        public Tree type() {
            return this.type;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitTypeCast((TypeCastTree)this);
        }
    }

    public static class InstanceOfTreeImpl
    extends JavaTree
    implements InstanceOfTree {
        private final ExpressionTree expression;
        private final Tree type;

        public InstanceOfTreeImpl(AstNode astNode, ExpressionTree expression, Tree type) {
            super(astNode);
            this.expression = Preconditions.checkNotNull(expression);
            this.type = Preconditions.checkNotNull(type);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.INSTANCE_OF;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public Tree type() {
            return this.type;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitInstanceOf((InstanceOfTree)this);
        }
    }

    public static class ConditionalExpressionTreeImpl
    extends JavaTree
    implements ConditionalExpressionTree {
        private final ExpressionTree condition;
        private final ExpressionTree trueExpression;
        private final ExpressionTree falseExpression;

        public ConditionalExpressionTreeImpl(AstNode astNode, ExpressionTree condition, ExpressionTree trueExpression, ExpressionTree falseExpression) {
            super(astNode);
            this.condition = Preconditions.checkNotNull(condition);
            this.trueExpression = Preconditions.checkNotNull(trueExpression);
            this.falseExpression = Preconditions.checkNotNull(falseExpression);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.CONDITIONAL_EXPRESSION;
        }

        public ExpressionTree condition() {
            return this.condition;
        }

        public ExpressionTree trueExpression() {
            return this.trueExpression;
        }

        public ExpressionTree falseExpression() {
            return this.falseExpression;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitConditionalExpression((ConditionalExpressionTree)this);
        }
    }

    public static class ParenthesizedTreeImpl
    extends JavaTree
    implements ParenthesizedTree {
        private final ExpressionTree expression;

        public ParenthesizedTreeImpl(AstNode astNode, ExpressionTree expression) {
            super(astNode);
            this.expression = Preconditions.checkNotNull(expression);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.PARENTHESIZED_EXPRESSION;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitParenthesized((ParenthesizedTree)this);
        }
    }

    public static class UnaryExpressionTreeImpl
    extends JavaTree
    implements UnaryExpressionTree {
        private final Tree.Kind kind;
        private final ExpressionTree expression;

        public UnaryExpressionTreeImpl(AstNode astNode, Tree.Kind kind, ExpressionTree expression) {
            super(astNode);
            this.kind = Preconditions.checkNotNull(kind);
            this.expression = Preconditions.checkNotNull(expression);
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitUnaryExpression((UnaryExpressionTree)this);
        }
    }

    public static class BinaryExpressionTreeImpl
    extends JavaTree
    implements BinaryExpressionTree {
        private final ExpressionTree leftOperand;
        private final Tree.Kind kind;
        private final ExpressionTree rightOperand;

        public BinaryExpressionTreeImpl(AstNode astNode, ExpressionTree leftOperand, Tree.Kind kind, ExpressionTree rightOperand) {
            super(astNode);
            this.leftOperand = Preconditions.checkNotNull(leftOperand);
            this.kind = Preconditions.checkNotNull(kind);
            this.rightOperand = Preconditions.checkNotNull(rightOperand);
        }

        public ExpressionTree leftOperand() {
            return this.leftOperand;
        }

        public ExpressionTree rightOperand() {
            return this.rightOperand;
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitBinaryExpression((BinaryExpressionTree)this);
        }
    }

    public static class LiteralTreeImpl
    extends JavaTree
    implements LiteralTree {
        private final Tree.Kind kind;

        public LiteralTreeImpl(AstNode astNode, Tree.Kind kind) {
            super(astNode);
            this.kind = Preconditions.checkNotNull(kind);
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        public String value() {
            return ((JavaTree)this).astNode.getTokenOriginalValue();
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitLiteral((LiteralTree)this);
        }
    }

    public static class VariableTreeImpl
    extends JavaTree
    implements VariableTree {
        private final ModifiersTree modifiers;
        private final Tree type;
        private final IdentifierTree simpleName;
        @Nullable
        private final ExpressionTree initializer;

        public VariableTreeImpl(AstNode astNode, ModifiersTree modifiers, Tree type, IdentifierTree simpleName, @Nullable ExpressionTree initializer) {
            super(astNode);
            this.modifiers = Preconditions.checkNotNull(modifiers);
            this.type = Preconditions.checkNotNull(type);
            this.simpleName = Preconditions.checkNotNull(simpleName);
            this.initializer = initializer;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.VARIABLE;
        }

        public ModifiersTree modifiers() {
            return this.modifiers;
        }

        public Tree type() {
            return this.type;
        }

        public IdentifierTree simpleName() {
            return this.simpleName;
        }

        @Nullable
        public ExpressionTree initializer() {
            return this.initializer;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitVariable((VariableTree)this);
        }
    }

    public static class EnumConstantTreeImpl
    extends VariableTreeImpl
    implements EnumConstantTree {
        public EnumConstantTreeImpl(AstNode astNode, ModifiersTree modifiers, Tree type, IdentifierTree simpleName, ExpressionTree initializer) {
            super(astNode, modifiers, type, simpleName, Preconditions.checkNotNull(initializer));
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ENUM_CONSTANT;
        }

        @Override
        public void accept(TreeVisitor visitor) {
            visitor.visitEnumConstant((EnumConstantTree)this);
        }
    }

    public static class LabeledStatementTreeImpl
    extends JavaTree
    implements LabeledStatementTree {
        private final IdentifierTree label;
        private final StatementTree statement;

        public LabeledStatementTreeImpl(AstNode astNode, IdentifierTree label, StatementTree statement) {
            super(astNode);
            this.label = Preconditions.checkNotNull(label);
            this.statement = Preconditions.checkNotNull(statement);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.LABELED_STATEMENT;
        }

        public IdentifierTree label() {
            return this.label;
        }

        public StatementTree statement() {
            return this.statement;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitLabeledStatement((LabeledStatementTree)this);
        }
    }

    public static class CatchTreeImpl
    extends JavaTree
    implements CatchTree {
        private final VariableTree parameter;
        private final BlockTree block;

        public CatchTreeImpl(AstNode astNode, VariableTree parameter, BlockTree block) {
            super(astNode);
            this.parameter = Preconditions.checkNotNull(parameter);
            this.block = Preconditions.checkNotNull(block);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.CATCH;
        }

        public VariableTree parameter() {
            return this.parameter;
        }

        public BlockTree block() {
            return this.block;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitCatch((CatchTree)this);
        }
    }

    public static class TryStatementTreeImpl
    extends JavaTree
    implements TryStatementTree {
        private final List<VariableTree> resources;
        private final BlockTree block;
        private final List<CatchTree> catches;
        @Nullable
        private final BlockTree finallyBlock;

        public TryStatementTreeImpl(AstNode astNode, List<VariableTree> resources, BlockTree block, List<CatchTree> catches, @Nullable BlockTree finallyBlock) {
            super(astNode);
            this.resources = Preconditions.checkNotNull(resources);
            this.block = Preconditions.checkNotNull(block);
            this.catches = Preconditions.checkNotNull(catches);
            this.finallyBlock = finallyBlock;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.TRY_STATEMENT;
        }

        public List<VariableTree> resources() {
            return this.resources;
        }

        public BlockTree block() {
            return this.block;
        }

        public List<CatchTree> catches() {
            return this.catches;
        }

        @Nullable
        public BlockTree finallyBlock() {
            return this.finallyBlock;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitTryStatement((TryStatementTree)this);
        }
    }

    public static class ThrowStatementTreeImpl
    extends JavaTree
    implements ThrowStatementTree {
        private final ExpressionTree expression;

        public ThrowStatementTreeImpl(AstNode astNode, ExpressionTree expression) {
            super(astNode);
            this.expression = Preconditions.checkNotNull(expression);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.THROW_STATEMENT;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitThrowStatement((ThrowStatementTree)this);
        }
    }

    public static class SynchronizedStatementTreeImpl
    extends JavaTree
    implements SynchronizedStatementTree {
        private final ExpressionTree expression;
        private final BlockTree block;

        public SynchronizedStatementTreeImpl(AstNode astNode, ExpressionTree expression, BlockTree block) {
            super(astNode);
            this.expression = Preconditions.checkNotNull(expression);
            this.block = Preconditions.checkNotNull(block);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.SYNCHRONIZED_STATEMENT;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public BlockTree block() {
            return this.block;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitSynchronizedStatement((SynchronizedStatementTree)this);
        }
    }

    public static class ReturnStatementTreeImpl
    extends JavaTree
    implements ReturnStatementTree {
        @Nullable
        private final ExpressionTree expression;

        public ReturnStatementTreeImpl(AstNode astNode, @Nullable ExpressionTree expression) {
            super(astNode);
            this.expression = expression;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.RETURN_STATEMENT;
        }

        @Nullable
        public ExpressionTree expression() {
            return this.expression;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitReturnStatement((ReturnStatementTree)this);
        }
    }

    public static class ContinueStatementTreeImpl
    extends JavaTree
    implements ContinueStatementTree {
        @Nullable
        private final IdentifierTree label;

        public ContinueStatementTreeImpl(AstNode astNode, @Nullable IdentifierTree label) {
            super(astNode);
            this.label = label;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.CONTINUE_STATEMENT;
        }

        @Nullable
        public IdentifierTree label() {
            return this.label;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitContinueStatement((ContinueStatementTree)this);
        }
    }

    public static class BreakStatementTreeImpl
    extends JavaTree
    implements BreakStatementTree {
        @Nullable
        private final IdentifierTree label;

        public BreakStatementTreeImpl(AstNode astNode, @Nullable IdentifierTree label) {
            super(astNode);
            this.label = label;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.BREAK_STATEMENT;
        }

        @Nullable
        public IdentifierTree label() {
            return this.label;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitBreakStatement((BreakStatementTree)this);
        }
    }

    public static class DoWhileStatementTreeImpl
    extends JavaTree
    implements DoWhileStatementTree {
        private final StatementTree statement;
        private final ExpressionTree condition;

        public DoWhileStatementTreeImpl(AstNode astNode, StatementTree statement, ExpressionTree condition) {
            super(astNode);
            this.statement = Preconditions.checkNotNull(statement);
            this.condition = Preconditions.checkNotNull(condition);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.DO_STATEMENT;
        }

        public StatementTree statement() {
            return this.statement;
        }

        public ExpressionTree condition() {
            return this.condition;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitDoWhileStatement((DoWhileStatementTree)this);
        }
    }

    public static class CaseLabelTreeImpl
    extends JavaTree
    implements CaseLabelTree {
        @Nullable
        private final ExpressionTree expression;

        public CaseLabelTreeImpl(AstNode astNode, @Nullable ExpressionTree expression) {
            super(astNode);
            this.expression = expression;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.CASE_LABEL;
        }

        @Nullable
        public ExpressionTree expression() {
            return this.expression;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitCaseLabel((CaseLabelTree)this);
        }
    }

    public static class CaseGroupTreeImpl
    extends JavaTree
    implements CaseGroupTree {
        private final List<CaseLabelTree> labels;
        private final List<StatementTree> body;

        public CaseGroupTreeImpl(AstNode astNode, List<CaseLabelTree> labels, List<StatementTree> body) {
            super(astNode);
            this.labels = Preconditions.checkNotNull(labels);
            this.body = Preconditions.checkNotNull(body);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.CASE_GROUP;
        }

        public List<CaseLabelTree> labels() {
            return this.labels;
        }

        public List<StatementTree> body() {
            return this.body;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitCaseGroup((CaseGroupTree)this);
        }
    }

    public static class SwitchStatementTreeImpl
    extends JavaTree
    implements SwitchStatementTree {
        private final ExpressionTree expression;
        private final List<CaseGroupTree> cases;

        public SwitchStatementTreeImpl(AstNode astNode, ExpressionTree expression, List<CaseGroupTree> cases) {
            super(astNode);
            this.expression = Preconditions.checkNotNull(expression);
            this.cases = Preconditions.checkNotNull(cases);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.SWITCH_STATEMENT;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public List<CaseGroupTree> cases() {
            return this.cases;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitSwitchStatement((SwitchStatementTree)this);
        }
    }

    public static class AssertStatementTreeImpl
    extends JavaTree
    implements AssertStatementTree {
        private final ExpressionTree condition;
        @Nullable
        private final ExpressionTree detail;

        public AssertStatementTreeImpl(AstNode astNode, ExpressionTree condition, @Nullable ExpressionTree detail) {
            super(astNode);
            this.condition = Preconditions.checkNotNull(condition);
            this.detail = detail;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.ASSERT_STATEMENT;
        }

        public ExpressionTree condition() {
            return this.condition;
        }

        @Nullable
        public ExpressionTree detail() {
            return this.detail;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitAssertStatement((AssertStatementTree)this);
        }
    }

    public static class ExpressionStatementTreeImpl
    extends JavaTree
    implements ExpressionStatementTree {
        private final ExpressionTree expression;

        public ExpressionStatementTreeImpl(AstNode astNode, ExpressionTree expression) {
            super(astNode);
            this.expression = Preconditions.checkNotNull(expression);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.EXPRESSION_STATEMENT;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitExpressionStatement((ExpressionStatementTree)this);
        }
    }

    public static class EmptyStatementTreeImpl
    extends JavaTree
    implements EmptyStatementTree {
        public EmptyStatementTreeImpl(AstNode astNode) {
            super(astNode);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.EMPTY_STATEMENT;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitEmptyStatement((EmptyStatementTree)this);
        }
    }

    public static class ForEachStatementImpl
    extends JavaTree
    implements ForEachStatement {
        private final VariableTree variable;
        private final ExpressionTree expression;
        private final StatementTree statement;

        public ForEachStatementImpl(AstNode astNode, VariableTree variable, ExpressionTree expression, StatementTree statement) {
            super(astNode);
            this.variable = Preconditions.checkNotNull(variable);
            this.expression = Preconditions.checkNotNull(expression);
            this.statement = Preconditions.checkNotNull(statement);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.FOR_EACH_STATEMENT;
        }

        public VariableTree variable() {
            return this.variable;
        }

        public ExpressionTree expression() {
            return this.expression;
        }

        public StatementTree statement() {
            return this.statement;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitForEachStatement((ForEachStatement)this);
        }
    }

    public static class ForStatementTreeImpl
    extends JavaTree
    implements ForStatementTree {
        private final List<StatementTree> initializer;
        @Nullable
        private final ExpressionTree condition;
        private final List<StatementTree> update;
        private final StatementTree statement;

        public ForStatementTreeImpl(AstNode astNode, List<StatementTree> initializer, @Nullable ExpressionTree condition, List<StatementTree> update, StatementTree statement) {
            super(astNode);
            this.initializer = Preconditions.checkNotNull(initializer);
            this.condition = condition;
            this.update = Preconditions.checkNotNull(update);
            this.statement = Preconditions.checkNotNull(statement);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.FOR_STATEMENT;
        }

        public List<StatementTree> initializer() {
            return this.initializer;
        }

        @Nullable
        public ExpressionTree condition() {
            return this.condition;
        }

        public List<StatementTree> update() {
            return this.update;
        }

        public StatementTree statement() {
            return this.statement;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitForStatement((ForStatementTree)this);
        }
    }

    public static class WhileStatementTreeImpl
    extends JavaTree
    implements WhileStatementTree {
        private final ExpressionTree condition;
        private final StatementTree statement;

        public WhileStatementTreeImpl(AstNode astNode, ExpressionTree condition, StatementTree statement) {
            super(astNode);
            this.condition = Preconditions.checkNotNull(condition);
            this.statement = Preconditions.checkNotNull(statement);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.WHILE_STATEMENT;
        }

        public ExpressionTree condition() {
            return this.condition;
        }

        public StatementTree statement() {
            return this.statement;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitWhileStatement((WhileStatementTree)this);
        }
    }

    public static class IfStatementTreeImpl
    extends JavaTree
    implements IfStatementTree {
        private final ExpressionTree condition;
        private final StatementTree thenStatement;
        @Nullable
        private final StatementTree elseStatement;

        public IfStatementTreeImpl(AstNode astNode, ExpressionTree condition, StatementTree thenStatement, @Nullable StatementTree elseStatement) {
            super(astNode);
            this.condition = Preconditions.checkNotNull(condition);
            this.thenStatement = Preconditions.checkNotNull(thenStatement);
            this.elseStatement = elseStatement;
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.IF_STATEMENT;
        }

        public ExpressionTree condition() {
            return this.condition;
        }

        public StatementTree thenStatement() {
            return this.thenStatement;
        }

        @Nullable
        public StatementTree elseStatement() {
            return this.elseStatement;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitIfStatement((IfStatementTree)this);
        }
    }

    public static class BlockTreeImpl
    extends JavaTree
    implements BlockTree {
        private final Tree.Kind kind;
        private final List<StatementTree> body;

        public BlockTreeImpl(AstNode astNode, Tree.Kind kind, List<StatementTree> body) {
            super(astNode);
            this.kind = kind;
            this.body = Preconditions.checkNotNull(body);
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        public List<StatementTree> body() {
            return this.body;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitBlock((BlockTree)this);
        }
    }

    public static class MethodTreeImpl
    extends JavaTree
    implements MethodTree {
        private final ModifiersTree modifiers;
        @Nullable
        private final Tree returnType;
        private final IdentifierTree simpleName;
        private final List<VariableTree> parameters;
        @Nullable
        private final BlockTree block;
        private final List<ExpressionTree> throwsClauses;
        private final ExpressionTree defaultValue;

        public MethodTreeImpl(AstNode astNode, ModifiersTree modifiers, @Nullable Tree returnType, IdentifierTree simpleName, List<VariableTree> parameters, @Nullable BlockTree block, List<ExpressionTree> throwsClauses, @Nullable ExpressionTree defaultValue) {
            super(astNode);
            this.modifiers = Preconditions.checkNotNull(modifiers);
            this.returnType = returnType;
            this.simpleName = Preconditions.checkNotNull(simpleName);
            this.parameters = Preconditions.checkNotNull(parameters);
            this.block = block;
            this.throwsClauses = Preconditions.checkNotNull(throwsClauses);
            this.defaultValue = defaultValue;
        }

        @Override
        public Tree.Kind getKind() {
            return this.returnType == null ? Tree.Kind.CONSTRUCTOR : Tree.Kind.METHOD;
        }

        public ModifiersTree modifiers() {
            return this.modifiers;
        }

        public List<Tree> typeParameters() {
            return ImmutableList.of();
        }

        @Nullable
        public Tree returnType() {
            return this.returnType;
        }

        public IdentifierTree simpleName() {
            return this.simpleName;
        }

        public List<VariableTree> parameters() {
            return this.parameters;
        }

        public List<ExpressionTree> throwsClauses() {
            return this.throwsClauses;
        }

        @Nullable
        public BlockTree block() {
            return this.block;
        }

        @Nullable
        public ExpressionTree defaultValue() {
            return this.defaultValue;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitMethod((MethodTree)this);
        }
    }

    public static class ClassTreeImpl
    extends JavaTree
    implements ClassTree {
        private final Tree.Kind kind;
        private final ModifiersTree modifiers;
        private final IdentifierTree simpleName;
        @Nullable
        private final Tree superClass;
        private final List<Tree> superInterfaces;
        private final List<Tree> members;

        public ClassTreeImpl(AstNode astNode, Tree.Kind kind, ModifiersTree modifiers, @Nullable IdentifierTree simpleName, @Nullable Tree superClass, List<Tree> superInterfaces, List<Tree> members) {
            super(astNode);
            this.kind = Preconditions.checkNotNull(kind);
            this.modifiers = Preconditions.checkNotNull(modifiers);
            this.simpleName = simpleName;
            this.superClass = superClass;
            this.superInterfaces = Preconditions.checkNotNull(superInterfaces);
            this.members = Preconditions.checkNotNull(members);
        }

        public ClassTreeImpl(AstNode astNode, Tree.Kind kind, ModifiersTree modifiers, List<Tree> members) {
            this(astNode, kind, modifiers, null, null, ImmutableList.of(), members);
        }

        @Override
        public Tree.Kind getKind() {
            return this.kind;
        }

        @Nullable
        public IdentifierTree simpleName() {
            return this.simpleName;
        }

        public List<Tree> typeParameters() {
            return ImmutableList.of();
        }

        public ModifiersTree modifiers() {
            return this.modifiers;
        }

        @Nullable
        public Tree superClass() {
            return this.superClass;
        }

        public List<Tree> superInterfaces() {
            return this.superInterfaces;
        }

        public List<Tree> members() {
            return this.members;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitClass((ClassTree)this);
        }
    }

    public static class ImportTreeImpl
    extends JavaTree
    implements ImportTree {
        private final boolean isStatic;
        private final Tree qualifiedIdentifier;

        public ImportTreeImpl(AstNode astNode, boolean aStatic, Tree qualifiedIdentifier) {
            super(astNode);
            this.isStatic = aStatic;
            this.qualifiedIdentifier = qualifiedIdentifier;
        }

        @Override
        public Tree.Kind getKind() {
            return null;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public Tree qualifiedIdentifier() {
            return this.qualifiedIdentifier;
        }

        public void accept(TreeVisitor visitor) {
        }
    }

    public static class CompilationUnitTreeImpl
    extends JavaTree
    implements CompilationUnitTree {
        @Nullable
        private final ExpressionTree packageName;
        private final List<ImportTree> imports;
        private final List<Tree> types;
        private final List<AnnotationTree> packageAnnotations;

        public CompilationUnitTreeImpl(AstNode astNode, @Nullable ExpressionTree packageName, List<ImportTree> imports, List<Tree> types, List<AnnotationTree> packageAnnotations) {
            super(astNode);
            this.packageName = packageName;
            this.imports = Preconditions.checkNotNull(imports);
            this.types = Preconditions.checkNotNull(types);
            this.packageAnnotations = Preconditions.checkNotNull(packageAnnotations);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.COMPILATION_UNIT;
        }

        public List<AnnotationTree> packageAnnotations() {
            return this.packageAnnotations;
        }

        @Nullable
        public ExpressionTree packageName() {
            return this.packageName;
        }

        public List<ImportTree> imports() {
            return this.imports;
        }

        public List<Tree> types() {
            return this.types;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitCompilationUnit((CompilationUnitTree)this);
        }
    }

    public static class IdentifierTreeImpl
    extends JavaTree
    implements IdentifierTree {
        private final String name;

        public IdentifierTreeImpl(AstNode astNode, String name) {
            super(astNode);
            this.name = Preconditions.checkNotNull(name);
        }

        @Override
        public Tree.Kind getKind() {
            return Tree.Kind.IDENTIFIER;
        }

        public String name() {
            return this.name;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitIdentifier((IdentifierTree)this);
        }

        public String toString() {
            return this.name;
        }
    }

    public static class PrimitiveTypeTreeImpl
    extends JavaTree
    implements PrimitiveTypeTree {
        public PrimitiveTypeTreeImpl(AstNode astNode) {
            super(astNode);
        }

        @Override
        public Tree.Kind getKind() {
            return null;
        }

        public void accept(TreeVisitor visitor) {
            visitor.visitPrimitiveType((PrimitiveTypeTree)this);
        }
    }
}

