/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.resolve;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.HashSet;
import org.sonar.java.model.JavaTree;
import org.sonar.java.resolve.Resolve;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.java.resolve.Symbol;
import org.sonar.java.resolve.Type;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;

public class SecondPass
implements Symbol.Completer {
    private final SemanticModel semanticModel;
    private final Resolve resolve;

    public SecondPass(SemanticModel semanticModel, Resolve resolve) {
        this.semanticModel = semanticModel;
        this.resolve = resolve;
    }

    @Override
    public void complete(Symbol symbol) {
        if (symbol.kind == 2) {
            this.complete((Symbol.TypeSymbol)symbol);
        } else if (symbol.kind == 16) {
            this.complete((Symbol.MethodSymbol)symbol);
        } else if (symbol.kind == 4) {
            this.complete((Symbol.VariableSymbol)symbol);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void complete(Symbol.TypeSymbol symbol) {
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        if ((symbol.flags() & 0x200) == 0) {
            symbol.members.enter(new Symbol.VariableSymbol(16, "this", symbol.type, (Symbol)symbol));
        }
        if ("".equals(symbol.name)) {
            ((Type.ClassType)symbol.type).interfaces = ImmutableList.of();
            return;
        }
        ClassTree tree = (ClassTree)this.semanticModel.getTree(symbol);
        Tree superClassTree = tree.superClass();
        if (superClassTree != null && (superClassTree.is(Tree.Kind.MEMBER_SELECT) || superClassTree.is(Tree.Kind.IDENTIFIER))) {
            ((Type.ClassType)symbol.type).supertype = this.resolveType((Resolve.Env)env, (Tree)superClassTree).type;
            this.checkHierarchyCycles(symbol.type);
        }
        ImmutableList.Builder interfaces = ImmutableList.builder();
        for (Tree interfaceTree : tree.superInterfaces()) {
            Type interfaceType = this.castToTypeIfPossible(this.resolveType(env, interfaceTree));
            if (interfaceType == null) continue;
            interfaces.add(interfaceType);
        }
        ((Type.ClassType)symbol.type).interfaces = interfaces.build();
    }

    private void checkHierarchyCycles(Type baseType) {
        HashSet<Type.ClassType> types = Sets.newHashSet();
        Type.ClassType type = (Type.ClassType)baseType;
        while (type != null) {
            if (!types.add(type)) {
                throw new IllegalStateException("Cycling class hierarchy detected with symbol : " + baseType.symbol.name + ".");
            }
            type = (Type.ClassType)type.symbol.getSuperclass();
        }
    }

    public void complete(Symbol.MethodSymbol symbol) {
        MethodTree methodTree = (MethodTree)this.semanticModel.getTree(symbol);
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        ImmutableList.Builder thrown = ImmutableList.builder();
        for (ExpressionTree throwClause : methodTree.throwsClauses()) {
            Type thrownType = this.castToTypeIfPossible(this.resolveType(env, (Tree)throwClause));
            if (thrownType == null) continue;
            thrown.add(((Type.ClassType)thrownType).symbol);
        }
        symbol.thrown = thrown.build();
        if ("<init>".equals(symbol.name)) {
            return;
        }
        Type type = this.castToTypeIfPossible(this.resolveType(env, methodTree.returnType()));
        if (type != null) {
            symbol.type = ((Type.ClassType)type).symbol;
        }
    }

    public void complete(Symbol.VariableSymbol symbol) {
        VariableTree variableTree = (VariableTree)this.semanticModel.getTree(symbol);
        Resolve.Env env = this.semanticModel.getEnv(symbol);
        symbol.type = variableTree.is(Tree.Kind.ENUM_CONSTANT) ? env.enclosingClass().type : this.castToTypeIfPossible(this.resolveType(env, variableTree.type()));
    }

    private Symbol resolveType(Resolve.Env env, Tree tree) {
        Preconditions.checkArgument(this.checkTypeOfTree(tree), "Kind of tree unexpected " + ((JavaTree)tree).getKind());
        TypeResolverVisitor typeResolverVisitor = new TypeResolverVisitor(env.dup());
        tree.accept((TreeVisitor)typeResolverVisitor);
        return typeResolverVisitor.site;
    }

    private boolean checkTypeOfTree(Tree tree) {
        return tree.is(Tree.Kind.MEMBER_SELECT) || tree.is(Tree.Kind.IDENTIFIER) || tree.is(Tree.Kind.PARAMETERIZED_TYPE) || tree.is(Tree.Kind.ARRAY_TYPE) || tree.is(Tree.Kind.UNION_TYPE) || tree instanceof PrimitiveTypeTree;
    }

    private Type castToTypeIfPossible(Symbol symbol) {
        return symbol instanceof Symbol.TypeSymbol ? ((Symbol.TypeSymbol)symbol).type : null;
    }

    private void associateReference(IdentifierTree tree, Symbol symbol) {
        if (symbol.kind < 64 && this.semanticModel.getTree(symbol) != null) {
            this.semanticModel.associateReference(tree, symbol);
        }
    }

    private class TypeResolverVisitor
    extends BaseTreeVisitor {
        private final Resolve.Env env;
        private Symbol site;

        public TypeResolverVisitor(Resolve.Env env) {
            this.env = env;
        }

        public void visitParameterizedType(ParameterizedTypeTree tree) {
            this.scan(tree.type());
        }

        public void visitArrayType(ArrayTypeTree tree) {
            super.visitArrayType(tree);
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            this.scan((Tree)tree.expression());
            if (this.site.kind >= 64) {
                return;
            }
            String name = tree.identifier().name();
            if (this.site.kind == 1) {
                this.env.packge = (Symbol.PackageSymbol)this.site;
                this.site = SecondPass.this.resolve.findIdentInPackage(this.env, this.site, name, 3);
            } else {
                this.env.enclosingClass = (Symbol.TypeSymbol)this.site;
                this.site = SecondPass.this.resolve.findMemberType(this.env, (Symbol.TypeSymbol)this.site, name, (Symbol.TypeSymbol)this.site);
            }
            SecondPass.this.associateReference(tree.identifier(), this.site);
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.site = SecondPass.this.resolve.findIdent(this.env, tree.name(), 3);
            SecondPass.this.associateReference(tree, this.site);
        }

        public void visitPrimitiveType(PrimitiveTypeTree tree) {
            this.site = SecondPass.this.resolve.findIdent(SecondPass.this.semanticModel.getEnv((Tree)tree), ((JavaTree)tree).getAstNode().getLastChild().getTokenValue(), 2);
        }
    }
}

