/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Rule;
import com.sonar.sslr.squid.checks.SquidCheck;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.api.EcmaScriptGrammar;
import org.sonar.squid.api.CodeCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@org.sonar.check.Rule(key="NestedIfDepth", priority=Priority.MINOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MINOR)
public class NestedIfDepthCheck
extends SquidCheck<EcmaScriptGrammar> {
    private int nestingLevel;
    private static final int DEFAULT_MAXIMUM_NESTING_LEVEL = 3;
    @RuleProperty(key="maximumNestingLevel", defaultValue="3")
    public int maximumNestingLevel = 3;

    public int getMaximumNestingLevel() {
        return this.maximumNestingLevel;
    }

    public Rule getIfRule() {
        return ((EcmaScriptGrammar)this.getContext().getGrammar()).ifStatement;
    }

    public void init() {
        this.subscribeTo(new AstNodeType[]{this.getIfRule()});
    }

    public void visitNode(AstNode astNode) {
        ++this.nestingLevel;
        if (this.nestingLevel == this.getMaximumNestingLevel() + 1) {
            this.getContext().createLineViolation((CodeCheck)this, "This if has a nesting level of {0}, which is higher than the maximum allowed {1}.", astNode, new Object[]{this.nestingLevel, this.getMaximumNestingLevel()});
        }
    }

    public void leaveNode(AstNode astNode) {
        --this.nestingLevel;
    }
}

