/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.sonar.check.BelongsToProfile;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="SameNameForFunctionAndVariable", priority=Priority.MAJOR)
@BelongsToProfile(title="Sonar way", priority=Priority.MAJOR)
public class SameNameForFunctionAndVariableCheck
extends SquidCheck<LexerlessGrammar> {
    private Stack<Set<String>> variablesStack;
    private Stack<Set<String>> functionsStack;

    public void init() {
        this.subscribeTo(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN, EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION});
    }

    public void visitFile(AstNode astNode) {
        this.variablesStack = new Stack();
        this.variablesStack.add(new HashSet());
        this.functionsStack = new Stack();
        this.functionsStack.add(new HashSet());
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION})) {
            String functionName = astNode.getFirstChild(new AstNodeType[]{EcmaScriptTokenType.IDENTIFIER}).getTokenValue();
            this.check(astNode, this.variablesStack.peek(), functionName);
            this.functionsStack.peek().add(functionName);
        } else if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_DECLARATION, EcmaScriptGrammar.VARIABLE_DECLARATION_NO_IN})) {
            String variableName = astNode.getTokenValue();
            this.check(astNode, this.functionsStack.peek(), variableName);
            this.variablesStack.peek().add(variableName);
        }
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION})) {
            this.variablesStack.add(new HashSet());
            this.functionsStack.add(new HashSet());
        }
    }

    private void check(AstNode astNode, Set<String> names, String name) {
        if (names.contains(name)) {
            this.getContext().createLineViolation((CodeCheck)this, "Refactor the code to avoid using '" + name + "' for both a variable and a function.", astNode, new Object[0]);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION})) {
            this.variablesStack.pop();
            this.functionsStack.pop();
        }
    }

    public void leaveFile(AstNode astNode) {
        this.variablesStack = null;
        this.functionsStack = null;
    }
}

