/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Arrays;
import java.util.List;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.expression.MemberExpressionTree;

public abstract class AbstractJQueryCheck
extends BaseTreeVisitor {
    private List<String> jQueryAliases = null;
    public static final String JQUERY_OBJECT_ALIASES = "sonar.javascript.jQueryObjectAliases";
    public static final String JQUERY_OBJECT_ALIASES_DEFAULT_VALUE = "$, jQuery";

    protected boolean isJQueryObject(String name) {
        if (this.jQueryAliases == null) {
            this.jQueryAliases = Arrays.asList(this.getContext().getPropertyValues(JQUERY_OBJECT_ALIASES));
        }
        return this.jQueryAliases.contains(name);
    }

    protected boolean isSelector(ExpressionTree expressionTree) {
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION})) {
            CallExpressionTree callExpressionTree = (CallExpressionTree)expressionTree;
            ExpressionTree callee = callExpressionTree.callee();
            if (callee.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
                String calleeName = ((IdentifierTree)callee).identifierToken().text();
                return this.isJQueryObject(calleeName);
            }
            return false;
        }
        return false;
    }

    protected boolean isMultiLevelSelector(ExpressionTree expressionTree) {
        if (this.isSelector(expressionTree)) {
            return true;
        }
        if (expressionTree.is(new Tree.Kind[]{Tree.Kind.CALL_EXPRESSION})) {
            ExpressionTree callee = ((CallExpressionTree)expressionTree).callee();
            return callee.is(new Tree.Kind[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && this.isMultiLevelSelector(((MemberExpressionTree)callee).object());
        }
        return false;
    }
}

