/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.CallExpressionTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S1442", name="\"alert(...)\" should not be used", priority=Priority.MAJOR, tags={"cwe", "security", "user-experience"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="10min")
public class AlertUseCheck
extends BaseTreeVisitor {
    public void visitCallExpression(CallExpressionTree tree) {
        ExpressionTree callee = tree.callee();
        if (callee.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER_REFERENCE}) && AlertUseCheck.isAlertCall((IdentifierTree)callee)) {
            this.getContext().addIssue((CodeVisitor)this, (Tree)tree, "Remove this usage of alert(...).");
        }
        super.visitCallExpression(tree);
    }

    public static boolean isAlertCall(IdentifierTree identifier) {
        return "alert".equals(identifier.name());
    }
}

