/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.SubscriptionBaseVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.AssignmentExpressionTree;
import org.sonar.javascript.model.interfaces.expression.BinaryExpressionTree;
import org.sonar.javascript.model.interfaces.expression.UnaryExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="BitwiseOperators", name="Bitwise operators should not be used", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class BitwiseOperatorsCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.builder().add((Object)Tree.Kind.BITWISE_AND).add((Object)Tree.Kind.BITWISE_OR).add((Object)Tree.Kind.BITWISE_XOR).add((Object)Tree.Kind.BITWISE_COMPLEMENT).add((Object)Tree.Kind.LEFT_SHIFT).add((Object)Tree.Kind.RIGHT_SHIFT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT).add((Object)Tree.Kind.AND_ASSIGNMENT).add((Object)Tree.Kind.OR_ASSIGNMENT).add((Object)Tree.Kind.XOR_ASSIGNMENT).add((Object)Tree.Kind.LEFT_SHIFT_ASSIGNMENT).add((Object)Tree.Kind.RIGHT_SHIFT_ASSIGNMENT).add((Object)Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT).build();
    }

    public void visitNode(Tree tree) {
        SyntaxToken operator = tree.is(new Tree.Kind[]{Tree.Kind.BITWISE_COMPLEMENT}) ? ((UnaryExpressionTree)tree).operator() : (tree instanceof BinaryExpressionTree ? ((BinaryExpressionTree)tree).operator() : ((AssignmentExpressionTree)tree).operator());
        this.getContext().addIssue((CodeVisitor)this, (Tree)operator, String.format("Remove the use of \"%s\" operator.", operator.text()));
    }
}

