/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQueryCheck;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.statement.IfStatementTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2769", name="Selection results should be tested with \"length\"", priority=Priority.CRITICAL, tags={"bug", "jquery"})
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class SelectionTestedWithoutLengthCheck
extends AbstractJQueryCheck {
    public void visitIfStatement(IfStatementTree tree) {
        ExpressionTree condition = tree.condition();
        if (this.isSelector(condition)) {
            this.getContext().addIssue((CodeVisitor)this, (Tree)condition, "Use the \"length\" property to see whether this selection contains elements.");
        }
        super.visitIfStatement(tree);
    }
}

