/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.javascript.ast.resolve.Symbol;
import org.sonar.javascript.ast.resolve.SymbolDeclaration;
import org.sonar.javascript.ast.resolve.SymbolModel;
import org.sonar.javascript.ast.visitors.BaseTreeVisitor;
import org.sonar.javascript.model.interfaces.declaration.ScriptTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeVisitor;

@Rule(key="S2703", name="Variables should always be declared with \"var\"", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class VariableDeclarationWithoutVarCheck
extends BaseTreeVisitor {
    private static final String MESSAGE = "Add the \"var\" keyword to this declaration of \"%s\".";

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        List symbols = symbolModel.getSymbols(new Symbol.Kind[]{Symbol.Kind.VARIABLE});
        for (Symbol symbol : symbols) {
            this.visitSymbol(symbol);
        }
    }

    private void visitSymbol(Symbol symbol) {
        if (symbol.getFirstDeclaration().is(new SymbolDeclaration.Kind[]{SymbolDeclaration.Kind.ASSIGNMENT, SymbolDeclaration.Kind.FOR_OF, SymbolDeclaration.Kind.FOR_IN})) {
            this.getContext().addIssue((CodeVisitor)this, symbol.getFirstDeclaration().tree(), String.format(MESSAGE, symbol.name()));
        }
    }
}

