/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.SeparatedList;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ObjectLiteralTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class ObjectLiteralTreeImpl
extends JavaScriptTree
implements ObjectLiteralTree {
    private SyntaxToken openCurlyBrace;
    private final SeparatedList<Tree> properties;
    private SyntaxToken closeCurlyBrace;

    public ObjectLiteralTreeImpl(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        super(Tree.Kind.OBJECT_LITERAL);
        this.openCurlyBrace = openCurlyBrace;
        this.closeCurlyBrace = closeCurlyBrace;
        this.properties = new SeparatedList(ListUtils.EMPTY_LIST, ListUtils.EMPTY_LIST);
        this.addChildren(openCurlyBrace, closeCurlyBrace);
    }

    public ObjectLiteralTreeImpl(SeparatedList<Tree> properties) {
        super(Tree.Kind.OBJECT_LITERAL);
        this.properties = properties;
        for (AstNode child : properties.getChildren()) {
            this.addChild(child);
        }
        properties.clearChildren();
    }

    public ObjectLiteralTreeImpl complete(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        this.openCurlyBrace = openCurlyBrace;
        this.closeCurlyBrace = closeCurlyBrace;
        this.prependChildren(openCurlyBrace);
        this.addChild(closeCurlyBrace);
        return this;
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public SeparatedList<Tree> properties() {
        return this.properties;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.OBJECT_LITERAL;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat((Iterator[])new Iterator[]{this.properties.iterator()});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitObjectLiteral(this);
    }
}

