/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.javascript.cpd;

import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.impl.Lexer;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.lexer.EcmaScriptLexer;

public class JavaScriptTokenizer
implements Tokenizer {
    private final Charset charset;

    public JavaScriptTokenizer(Charset charset) {
        this.charset = charset;
    }

    public final void tokenize(SourceCode source, Tokens cpdTokens) {
        Lexer lexer = EcmaScriptLexer.create((EcmaScriptConfiguration)new EcmaScriptConfiguration(this.charset));
        String fileName = source.getFileName();
        List tokens = lexer.lex(new File(fileName));
        for (Token token : tokens) {
            TokenEntry cpdToken = new TokenEntry(this.getTokenImage(token), fileName, token.getLine());
            cpdTokens.add(cpdToken);
        }
        cpdTokens.add(TokenEntry.getEOF());
    }

    private String getTokenImage(Token token) {
        if (token.getType() == GenericTokenType.LITERAL) {
            return GenericTokenType.LITERAL.getValue();
        }
        return token.getValue();
    }
}

