/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.CommentAnalyser;
import com.sonar.sslr.impl.Parser;
import com.sonar.sslr.impl.events.ParsingEventListener;
import com.sonar.sslr.squid.AstScanner;
import com.sonar.sslr.squid.SourceCodeBuilderCallback;
import com.sonar.sslr.squid.SourceCodeBuilderVisitor;
import com.sonar.sslr.squid.SquidAstVisitor;
import com.sonar.sslr.squid.SquidAstVisitorContextImpl;
import com.sonar.sslr.squid.metrics.CommentsVisitor;
import com.sonar.sslr.squid.metrics.CounterVisitor;
import com.sonar.sslr.squid.metrics.LinesOfCodeVisitor;
import com.sonar.sslr.squid.metrics.LinesVisitor;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.sonar.javascript.CharsetAwareVisitor;
import org.sonar.javascript.EcmaScriptCommentAnalyser;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.ProgressAstScanner;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.model.TreeVisitor;
import org.sonar.javascript.model.TreeVisitorsBridge;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.javascript.parser.EcmaScriptParser;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceFunction;
import org.sonar.squid.api.SourceProject;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public final class JavaScriptAstScanner {
    private JavaScriptAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<LexerlessGrammar> scanner = JavaScriptAstScanner.create(new EcmaScriptConfiguration(Charsets.UTF_8), visitors);
        scanner.scanFile(file);
        Collection<SourceCode> sources = scanner.getIndex().search(new QueryByType(SourceFile.class));
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<LexerlessGrammar> create(EcmaScriptConfiguration conf, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        SquidAstVisitorContextImpl context = new SquidAstVisitorContextImpl(new SourceProject("JavaScript Project"));
        Parser<LexerlessGrammar> parser = EcmaScriptParser.create(conf, new ParsingEventListener[0]);
        AstScanner.Builder builder = new ProgressAstScanner.Builder((SquidAstVisitorContextImpl<LexerlessGrammar>)context).setBaseParser(parser);
        builder.withMetrics((MetricDef[])EcmaScriptMetric.values());
        builder.setCommentAnalyser((CommentAnalyser)new EcmaScriptCommentAnalyser());
        builder.setFilesMetric((MetricDef)EcmaScriptMetric.FILES);
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.FUNCTIONS).subscribeTo(new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                AstNode identifier = astNode.getFirstChild(EcmaScriptTokenType.IDENTIFIER);
                String functionName = identifier == null ? "anonymous" : identifier.getTokenValue();
                String fileKey = parentSourceCode.isType(SourceFile.class) ? parentSourceCode.getKey() : parentSourceCode.getParent(SourceFile.class).getKey();
                SourceFunction function = new SourceFunction(fileKey + ":" + functionName + ":" + astNode.getToken().getLine() + ":" + astNode.getToken().getColumn());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, new AstNodeType[]{EcmaScriptGrammar.FUNCTION_DECLARATION, EcmaScriptGrammar.FUNCTION_EXPRESSION}));
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesVisitor((MetricDef)EcmaScriptMetric.LINES));
        builder.withSquidAstVisitor((SquidAstVisitor)new LinesOfCodeVisitor((MetricDef)EcmaScriptMetric.LINES_OF_CODE));
        builder.withSquidAstVisitor((SquidAstVisitor)CommentsVisitor.builder().withCommentMetric((MetricDef)EcmaScriptMetric.COMMENT_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor((SquidAstVisitor)CounterVisitor.builder().setMetricDef((MetricDef)EcmaScriptMetric.STATEMENTS).subscribeTo(new AstNodeType[]{EcmaScriptGrammar.VARIABLE_STATEMENT, EcmaScriptGrammar.EMPTY_STATEMENT, EcmaScriptGrammar.EXPRESSION_STATEMENT, EcmaScriptGrammar.IF_STATEMENT, EcmaScriptGrammar.ITERATION_STATEMENT, EcmaScriptGrammar.CONTINUE_STATEMENT, EcmaScriptGrammar.BREAK_STATEMENT, EcmaScriptGrammar.RETURN_STATEMENT, EcmaScriptGrammar.WITH_STATEMENT, EcmaScriptGrammar.SWITCH_STATEMENT, EcmaScriptGrammar.THROW_STATEMENT, EcmaScriptGrammar.TRY_STATEMENT, EcmaScriptGrammar.DEBUGGER_STATEMENT}).build());
        builder.withSquidAstVisitor((SquidAstVisitor)new ComplexityVisitor());
        ImmutableList.Builder treeVisitors = ImmutableList.builder();
        for (SquidAstVisitor<LexerlessGrammar> visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                ((CharsetAwareVisitor)visitor).setCharset(conf.getCharset());
            }
            if (visitor instanceof TreeVisitor) {
                treeVisitors.add((TreeVisitor)visitor);
            }
            builder.withSquidAstVisitor(visitor);
        }
        TreeVisitorsBridge treeVisitorsBridge = new TreeVisitorsBridge((List<? extends TreeVisitor>)((Object)treeVisitors.build()));
        builder.withSquidAstVisitor((SquidAstVisitor)treeVisitorsBridge);
        return builder.build();
    }
}

