/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.javascript.model.TreeVisitor;

public class VisitorsDispatcher {
    private final List<? extends Object> visitors;
    private final Set<Class> visitorClasses;
    private final Map<Class, Map<Class, Method>> visitMethods = Maps.newHashMap();
    private final Map<Class, Map<Class, Method>> leaveMethods = Maps.newHashMap();

    public VisitorsDispatcher(List<? extends TreeVisitor> visitors) {
        this.visitors = visitors;
        ImmutableSet.Builder visitorClassesBuilder = ImmutableSet.builder();
        for (TreeVisitor treeVisitor : visitors) {
            visitorClassesBuilder.add(treeVisitor.getClass());
        }
        this.visitorClasses = visitorClassesBuilder.build();
    }

    public void visit(Object node, Class<?> nodeClass) {
        this.invoke(this.visitMethods, false, nodeClass, node);
    }

    public void leave(Object node, Class<?> nodeClass) {
        this.invoke(this.leaveMethods, true, nodeClass, node);
    }

    private void invoke(Map<Class, Map<Class, Method>> cache, boolean leave, Class<?> nodeClass, Object node) {
        Map<Class, Method> methods = cache.get(nodeClass);
        if (methods == null) {
            methods = this.lookup(leave, nodeClass);
            cache.put(nodeClass, methods);
        }
        for (Object object : leave ? Lists.reverse(this.visitors) : this.visitors) {
            Method method = methods.get(object.getClass());
            if (method == null) continue;
            try {
                method.invoke(object, node);
            }
            catch (IllegalAccessException e) {
                throw Throwables.propagate(e);
            }
            catch (InvocationTargetException e) {
                throw Throwables.propagate(e);
            }
        }
    }

    private Map<Class, Method> lookup(boolean leave, Class<?> nodeClass) {
        ImmutableMap.Builder<Class, Method> methodsBuilder = ImmutableMap.builder();
        for (Class visitorClass : this.visitorClasses) {
            Method method = VisitorsDispatcher.lookup(visitorClass, leave ? "leave" : "visit", nodeClass);
            if (method == null) continue;
            methodsBuilder.put(visitorClass, method);
        }
        return methodsBuilder.build();
    }

    @Nullable
    private static Method lookup(Class<?> visitorClass, String methodName, Class<?> nodeClass) {
        try {
            return visitorClass.getMethod(methodName, nodeClass);
        }
        catch (NoSuchMethodException e) {
            Class<?>[] arr$ = nodeClass.getInterfaces();
            int len$ = arr$.length;
            int i$ = 0;
            if (i$ < len$) {
                Class<?> base = arr$[i$];
                return VisitorsDispatcher.lookup(visitorClass, methodName, base);
            }
            return null;
        }
    }
}

