/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.parser;

import com.sonar.sslr.api.GenericTokenType;
import org.sonar.javascript.api.EcmaScriptKeyword;
import org.sonar.javascript.api.EcmaScriptPunctuator;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.grammar.LexerlessGrammarBuilder;
import org.sonar.sslr.parser.LexerlessGrammar;

public enum EcmaScriptGrammar implements GrammarRuleKey
{
    EOF,
    EOS,
    EOS_NO_LB,
    IDENTIFIER_NAME,
    CONDITION,
    LITERAL,
    NULL_LITERAL,
    BOOLEAN_LITERAL,
    STRING_LITERAL,
    KEYWORD,
    LETTER_OR_DIGIT,
    SPACING,
    SPACING_NO_LB,
    NEXT_NOT_LB,
    LINE_TERMINATOR_SEQUENCE,
    PRIMARY_EXPRESSION,
    ARRAY_LITERAL,
    OBJECT_LITERAL,
    PROPERTY_ASSIGNMENT,
    PROPERTY_NAME,
    PROPERTY_SET_PARAMETER_LIST,
    MEMBER_EXPRESSION,
    NEW_EXPRESSION,
    CALL_EXPRESSION,
    ARGUMENTS,
    LEFT_HAND_SIDE_EXPRESSION,
    POSTFIX_EXPRESSION,
    UNARY_EXPRESSION,
    MULTIPLICATIVE_EXPRESSION,
    ADDITIVE_EXPRESSION,
    SHIFT_EXPRESSION,
    RELATIONAL_EXPRESSION,
    RELATIONAL_EXPRESSION_NO_IN,
    EQUALITY_EXPRESSION,
    EQUALITY_EXPRESSION_NO_IN,
    BITWISE_AND_EXPRESSION,
    BITWISE_AND_EXPRESSION_NO_IN,
    BITWISE_XOR_EXPRESSION,
    BITWISE_XOR_EXPRESSION_NO_IN,
    BITWISE_OR_EXPRESSION,
    BITWISE_OR_EXPRESSION_NO_IN,
    LOGICAL_AND_EXPRESSION,
    LOGICAL_AND_EXPRESSION_NO_IN,
    LOGICAL_OR_EXPRESSION,
    LOGICAL_OR_EXPRESSION_NO_IN,
    CONDITIONAL_EXPRESSION,
    CONDITIONAL_EXPRESSION_NO_IN,
    ASSIGNMENT_EXPRESSION,
    ASSIGNMENT_EXPRESSION_NO_IN,
    ASSIGNMENT_OPERATOR,
    EXPRESSION,
    EXPRESSION_NO_IN,
    STATEMENT,
    BLOCK,
    STATEMENT_LIST,
    VARIABLE_STATEMENT,
    VARIABLE_DECLARATION_LIST,
    VARIABLE_DECLARATION_LIST_NO_IN,
    VARIABLE_DECLARATION,
    VARIABLE_DECLARATION_NO_IN,
    INITIALISER,
    INITIALISER_NO_IN,
    EMPTY_STATEMENT,
    EXPRESSION_STATEMENT,
    IF_STATEMENT,
    ELSE_CLAUSE,
    ITERATION_STATEMENT,
    DO_WHILE_STATEMENT,
    WHILE_STATEMENT,
    FOR_IN_STATEMENT,
    FOR_STATEMENT,
    CONTINUE_STATEMENT,
    BREAK_STATEMENT,
    RETURN_STATEMENT,
    WITH_STATEMENT,
    SWITCH_STATEMENT,
    CASE_BLOCK,
    CASE_CLAUSES,
    CASE_CLAUSE,
    DEFAULT_CLAUSE,
    LABELLED_STATEMENT,
    THROW_STATEMENT,
    TRY_STATEMENT,
    CATCH,
    FINALLY,
    DEBUGGER_STATEMENT,
    FUNCTION_DECLARATION,
    FUNCTION_EXPRESSION,
    FORMAL_PARAMETER_LIST,
    FUNCTION_BODY,
    PROGRAM,
    SOURCE_ELEMENTS,
    SOURCE_ELEMENT,
    SHEBANG;

    private final String internalName;

    public static LexerlessGrammar createGrammar() {
        return EcmaScriptGrammar.createGrammarBuilder().build();
    }

    public static LexerlessGrammarBuilder createGrammarBuilder() {
        LexerlessGrammarBuilder b = LexerlessGrammarBuilder.create();
        b.rule(IDENTIFIER_NAME).is(SPACING, b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+"));
        b.rule(LITERAL).is(b.firstOf(NULL_LITERAL, BOOLEAN_LITERAL, EcmaScriptTokenType.NUMERIC_LITERAL, STRING_LITERAL, EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL));
        b.rule(NULL_LITERAL).is(EcmaScriptKeyword.NULL);
        b.rule(BOOLEAN_LITERAL).is(b.firstOf(EcmaScriptKeyword.TRUE, EcmaScriptKeyword.FALSE));
        EcmaScriptGrammar.lexical(b);
        EcmaScriptGrammar.expressions(b);
        EcmaScriptGrammar.statements(b);
        EcmaScriptGrammar.functionsAndPrograms(b);
        b.setRootRule(PROGRAM);
        return b;
    }

    private static void lexical(LexerlessGrammarBuilder b) {
        b.rule(SPACING).is(b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")), b.zeroOrMore(b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[\\s\\S]*?\\*/)")), b.skippedTrivia(b.regexp("[\\n\\r\\u2028\\u2029\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]*+")))).skip();
        b.rule(SPACING_NO_LB).is(b.zeroOrMore(b.firstOf(b.skippedTrivia(b.regexp("[\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]++")), b.commentTrivia(b.regexp("(?://[^\\n\\r]*+|<!--[^\\n\\r]*+|/\\*[^\\n\\r]*?\\*/)"))))).skip();
        b.rule(NEXT_NOT_LB).is(b.nextNot(b.regexp("(?:/\\*[\\s\\S]*?\\*/|[\\n\\r\\u2028\\u2029])"))).skip();
        b.rule(LINE_TERMINATOR_SEQUENCE).is(b.skippedTrivia(b.regexp("(?:\\n|\\r\\n|\\r|\\u2028|\\u2029)"))).skip();
        b.rule(EOS).is(b.firstOf(b.sequence(SPACING, EcmaScriptPunctuator.SEMI), b.sequence(SPACING_NO_LB, LINE_TERMINATOR_SEQUENCE), b.sequence(SPACING_NO_LB, b.next("}")), b.sequence(SPACING, b.endOfInput())));
        b.rule(EOS_NO_LB).is(b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptPunctuator.SEMI), b.sequence(SPACING_NO_LB, LINE_TERMINATOR_SEQUENCE), b.sequence(SPACING_NO_LB, b.next("}")), b.sequence(SPACING_NO_LB, b.endOfInput())));
        b.rule(EOF).is(b.token(GenericTokenType.EOF, b.endOfInput())).skip();
        b.rule(EcmaScriptTokenType.IDENTIFIER).is(SPACING, b.nextNot(KEYWORD), b.regexp("(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])(?:(?:[$_\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}]|\\\\u[0-9a-fA-F][0-9a-fA-F][0-9a-fA-F][0-9a-fA-F])|[\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}])*+"));
        b.rule(EcmaScriptTokenType.NUMERIC_LITERAL).is(SPACING, b.regexp("(?:[0-9]++\\.([0-9]++)?+([Ee][+-]?+[0-9_]++)?+[fFdD]?+|\\.[0-9]++([Ee][+-]?+[0-9_]++)?+[fFdD]?+|[0-9]++[fFdD]|[0-9]++([Ee][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++\\.[0-9a-fA-F_]*+([Pp][+-]?+[0-9_]++)?+[fFdD]?+|0[xX][0-9a-fA-F]++([Pp][+-]?+[0-9_]++)[fFdD]?+|0[xX][0-9a-fA-F]++[lL]?+|0[bB][01]++[lL]?+|[0-9]++[lL]?+)"));
        b.rule(STRING_LITERAL).is(SPACING, b.token(GenericTokenType.LITERAL, b.regexp("(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')")));
        b.rule(EcmaScriptTokenType.REGULAR_EXPRESSION_LITERAL).is(SPACING, b.regexp("\\/(?![*/])(?:[^\\\\\\[/&&[^\\r\\n\\u2028\\u2029]]|\\[(?:[^\\]\\\\&&[^\\r\\n\\u2028\\u2029]]|\\\\[^\\r\\n\\u2028\\u2029])*+\\]|\\\\[^\\r\\n\\u2028\\u2029])*+\\/\\p{javaJavaIdentifierPart}*+"));
        EcmaScriptGrammar.punctuators(b);
        EcmaScriptGrammar.keywords(b);
    }

    private static void punctuators(LexerlessGrammarBuilder b) {
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LCURLYBRACE, "{");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RCURLYBRACE, "}");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LPARENTHESIS, "(");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RPARENTHESIS, ")");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LBRACKET, "[");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.RBRACKET, "]");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DOT, ".");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SEMI, ";");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COMMA, ",");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LT, "<", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GT, ">", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.LE, "<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.GE, ">=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL, "==", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL, "!=", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQUAL2, "===");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.NOTEQUAL2, "!==");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS, "+", b.nextNot(b.firstOf("+", "=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS, "-", b.nextNot(b.firstOf("-", "=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR, "*", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD, "%", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV, "/", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.INC, "++");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DEC, "--");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL, "<<", b.nextNot(b.firstOf("<", "=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR, ">>", b.nextNot(b.firstOf(">", "=")));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR2, ">>>");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND, "&", b.nextNot("&", "="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR, "|", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR, "^", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.BANG, "!", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.TILDA, "~");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.ANDAND, "&&");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OROR, "||");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.QUERY, "?");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.COLON, ":");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.EQU, "=", b.nextNot("="));
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.PLUS_EQU, "+=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MINUS_EQU, "-=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.DIV_EQU, "/=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.STAR_EQU, "*=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.MOD_EQU, "%=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SL_EQU, "<<=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU, ">>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.SR_EQU2, ">>>=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.AND_EQU, "&=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.OR_EQU, "|=");
        EcmaScriptGrammar.punctuator(b, EcmaScriptPunctuator.XOR_EQU, "^=");
    }

    private static void keywords(LexerlessGrammarBuilder b) {
        b.rule(LETTER_OR_DIGIT).is(b.regexp("\\p{javaJavaIdentifierPart}"));
        Object[] rest = new Object[EcmaScriptKeyword.values().length - 2];
        for (int i = 0; i < EcmaScriptKeyword.values().length; ++i) {
            EcmaScriptKeyword tokenType = EcmaScriptKeyword.values()[i];
            b.rule(tokenType).is(SPACING, tokenType.getValue(), b.nextNot(LETTER_OR_DIGIT));
            if (i <= 1) continue;
            rest[i - 2] = tokenType.getValue();
        }
        b.rule(KEYWORD).is(b.firstOf(EcmaScriptKeyword.keywordValues()[0], EcmaScriptKeyword.keywordValues()[1], rest), b.nextNot(LETTER_OR_DIGIT));
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule(tokenType).is(SPACING, value);
            return;
        }
        throw new IllegalStateException(value);
    }

    private static Object word(LexerlessGrammarBuilder b, String value) {
        return b.sequence(SPACING, b.token(GenericTokenType.IDENTIFIER, value));
    }

    private static void punctuator(LexerlessGrammarBuilder b, GrammarRuleKey ruleKey, String value, Object element) {
        for (EcmaScriptPunctuator tokenType : EcmaScriptPunctuator.values()) {
            if (!value.equals(tokenType.getValue())) continue;
            b.rule(tokenType).is(SPACING, value, element);
            return;
        }
        throw new IllegalStateException(value);
    }

    private static void expressions(LexerlessGrammarBuilder b) {
        b.rule(PRIMARY_EXPRESSION).is(b.firstOf(EcmaScriptKeyword.THIS, EcmaScriptTokenType.IDENTIFIER, LITERAL, ARRAY_LITERAL, OBJECT_LITERAL, b.sequence(EcmaScriptPunctuator.LPARENTHESIS, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS)));
        b.rule(ARRAY_LITERAL).is(EcmaScriptPunctuator.LBRACKET, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.COMMA, ASSIGNMENT_EXPRESSION)), EcmaScriptPunctuator.RBRACKET);
        b.rule(OBJECT_LITERAL).is(EcmaScriptPunctuator.LCURLYBRACE, b.optional(PROPERTY_ASSIGNMENT, b.zeroOrMore(EcmaScriptPunctuator.COMMA, PROPERTY_ASSIGNMENT), b.optional(EcmaScriptPunctuator.COMMA)), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(PROPERTY_ASSIGNMENT).is(b.firstOf(b.sequence(PROPERTY_NAME, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION), b.sequence(EcmaScriptGrammar.word(b, "get"), PROPERTY_NAME, EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE), b.sequence(EcmaScriptGrammar.word(b, "set"), PROPERTY_NAME, EcmaScriptPunctuator.LPARENTHESIS, PROPERTY_SET_PARAMETER_LIST, EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE)));
        b.rule(PROPERTY_NAME).is(b.firstOf(IDENTIFIER_NAME, STRING_LITERAL, EcmaScriptTokenType.NUMERIC_LITERAL));
        b.rule(PROPERTY_SET_PARAMETER_LIST).is(EcmaScriptTokenType.IDENTIFIER);
        b.rule(MEMBER_EXPRESSION).is(b.firstOf(PRIMARY_EXPRESSION, FUNCTION_EXPRESSION, b.sequence(EcmaScriptKeyword.NEW, MEMBER_EXPRESSION, ARGUMENTS)), b.zeroOrMore(b.firstOf(b.sequence(EcmaScriptPunctuator.LBRACKET, EXPRESSION, EcmaScriptPunctuator.RBRACKET), b.sequence(EcmaScriptPunctuator.DOT, IDENTIFIER_NAME))));
        b.rule(NEW_EXPRESSION).is(b.firstOf(MEMBER_EXPRESSION, b.sequence(EcmaScriptKeyword.NEW, NEW_EXPRESSION)));
        b.rule(CALL_EXPRESSION).is(b.sequence(MEMBER_EXPRESSION, ARGUMENTS), b.zeroOrMore(b.firstOf(ARGUMENTS, b.sequence(EcmaScriptPunctuator.LBRACKET, EXPRESSION, EcmaScriptPunctuator.RBRACKET), b.sequence(EcmaScriptPunctuator.DOT, IDENTIFIER_NAME))));
        b.rule(ARGUMENTS).is(EcmaScriptPunctuator.LPARENTHESIS, b.optional(ASSIGNMENT_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.COMMA, ASSIGNMENT_EXPRESSION)), EcmaScriptPunctuator.RPARENTHESIS);
        b.rule(LEFT_HAND_SIDE_EXPRESSION).is(b.firstOf(CALL_EXPRESSION, NEW_EXPRESSION));
        b.rule(POSTFIX_EXPRESSION).is(LEFT_HAND_SIDE_EXPRESSION, b.optional(SPACING_NO_LB, NEXT_NOT_LB, b.firstOf(EcmaScriptPunctuator.INC, EcmaScriptPunctuator.DEC)));
        b.rule(UNARY_EXPRESSION).is(b.firstOf(POSTFIX_EXPRESSION, b.sequence(EcmaScriptKeyword.DELETE, UNARY_EXPRESSION), b.sequence(EcmaScriptKeyword.VOID, UNARY_EXPRESSION), b.sequence(EcmaScriptKeyword.TYPEOF, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.INC, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.DEC, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.PLUS, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.MINUS, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.TILDA, UNARY_EXPRESSION), b.sequence(EcmaScriptPunctuator.BANG, UNARY_EXPRESSION)));
        b.rule(MULTIPLICATIVE_EXPRESSION).is(UNARY_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.STAR, EcmaScriptPunctuator.DIV, EcmaScriptPunctuator.MOD), UNARY_EXPRESSION)).skipIfOneChild();
        b.rule(ADDITIVE_EXPRESSION).is(MULTIPLICATIVE_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.PLUS, EcmaScriptPunctuator.MINUS), MULTIPLICATIVE_EXPRESSION)).skipIfOneChild();
        b.rule(SHIFT_EXPRESSION).is(ADDITIVE_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.SL, EcmaScriptPunctuator.SR, EcmaScriptPunctuator.SR2), ADDITIVE_EXPRESSION)).skipIfOneChild();
        b.rule(RELATIONAL_EXPRESSION).is(SHIFT_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.LT, EcmaScriptPunctuator.GT, EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF, EcmaScriptKeyword.IN), SHIFT_EXPRESSION)).skipIfOneChild();
        b.rule(RELATIONAL_EXPRESSION_NO_IN).is(SHIFT_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.LT, EcmaScriptPunctuator.GT, EcmaScriptPunctuator.LE, EcmaScriptPunctuator.GE, EcmaScriptKeyword.INSTANCEOF), SHIFT_EXPRESSION)).skipIfOneChild();
        b.rule(EQUALITY_EXPRESSION).is(RELATIONAL_EXPRESSION, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.EQUAL, EcmaScriptPunctuator.NOTEQUAL, EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2), RELATIONAL_EXPRESSION)).skipIfOneChild();
        b.rule(EQUALITY_EXPRESSION_NO_IN).is(RELATIONAL_EXPRESSION_NO_IN, b.zeroOrMore(b.firstOf(EcmaScriptPunctuator.EQUAL, EcmaScriptPunctuator.NOTEQUAL, EcmaScriptPunctuator.EQUAL2, EcmaScriptPunctuator.NOTEQUAL2), RELATIONAL_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(BITWISE_AND_EXPRESSION).is(EQUALITY_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.AND, EQUALITY_EXPRESSION)).skipIfOneChild();
        b.rule(BITWISE_AND_EXPRESSION_NO_IN).is(EQUALITY_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.AND, EQUALITY_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(BITWISE_XOR_EXPRESSION).is(BITWISE_AND_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.XOR, BITWISE_AND_EXPRESSION)).skipIfOneChild();
        b.rule(BITWISE_XOR_EXPRESSION_NO_IN).is(BITWISE_AND_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.XOR, BITWISE_AND_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(BITWISE_OR_EXPRESSION).is(BITWISE_XOR_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.OR, BITWISE_XOR_EXPRESSION)).skipIfOneChild();
        b.rule(BITWISE_OR_EXPRESSION_NO_IN).is(BITWISE_XOR_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.OR, BITWISE_XOR_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(LOGICAL_AND_EXPRESSION).is(BITWISE_OR_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.ANDAND, BITWISE_OR_EXPRESSION)).skipIfOneChild();
        b.rule(LOGICAL_AND_EXPRESSION_NO_IN).is(BITWISE_OR_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.ANDAND, BITWISE_OR_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(LOGICAL_OR_EXPRESSION).is(LOGICAL_AND_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.OROR, LOGICAL_AND_EXPRESSION)).skipIfOneChild();
        b.rule(LOGICAL_OR_EXPRESSION_NO_IN).is(LOGICAL_AND_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.OROR, LOGICAL_AND_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(CONDITIONAL_EXPRESSION).is(LOGICAL_OR_EXPRESSION, b.optional(EcmaScriptPunctuator.QUERY, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION)).skipIfOneChild();
        b.rule(CONDITIONAL_EXPRESSION_NO_IN).is(LOGICAL_OR_EXPRESSION_NO_IN, b.optional(EcmaScriptPunctuator.QUERY, ASSIGNMENT_EXPRESSION, EcmaScriptPunctuator.COLON, ASSIGNMENT_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(ASSIGNMENT_EXPRESSION).is(b.firstOf(b.sequence(LEFT_HAND_SIDE_EXPRESSION, ASSIGNMENT_OPERATOR, ASSIGNMENT_EXPRESSION), CONDITIONAL_EXPRESSION)).skipIfOneChild();
        b.rule(ASSIGNMENT_EXPRESSION_NO_IN).is(b.firstOf(b.sequence(LEFT_HAND_SIDE_EXPRESSION, ASSIGNMENT_OPERATOR, ASSIGNMENT_EXPRESSION_NO_IN), CONDITIONAL_EXPRESSION_NO_IN)).skipIfOneChild();
        b.rule(ASSIGNMENT_OPERATOR).is(b.firstOf(EcmaScriptPunctuator.EQU, EcmaScriptPunctuator.STAR_EQU, EcmaScriptPunctuator.DIV_EQU, EcmaScriptPunctuator.MOD_EQU, EcmaScriptPunctuator.PLUS_EQU, EcmaScriptPunctuator.MINUS_EQU, EcmaScriptPunctuator.SL_EQU, EcmaScriptPunctuator.SR_EQU, EcmaScriptPunctuator.SR_EQU2, EcmaScriptPunctuator.AND_EQU, EcmaScriptPunctuator.XOR_EQU, EcmaScriptPunctuator.OR_EQU)).skip();
        b.rule(EXPRESSION).is(ASSIGNMENT_EXPRESSION, b.zeroOrMore(EcmaScriptPunctuator.COMMA, ASSIGNMENT_EXPRESSION));
        b.rule(EXPRESSION_NO_IN).is(ASSIGNMENT_EXPRESSION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.COMMA, ASSIGNMENT_EXPRESSION_NO_IN));
    }

    private static void statements(LexerlessGrammarBuilder b) {
        b.rule(STATEMENT).is(b.firstOf(BLOCK, VARIABLE_STATEMENT, EMPTY_STATEMENT, LABELLED_STATEMENT, EXPRESSION_STATEMENT, IF_STATEMENT, ITERATION_STATEMENT, CONTINUE_STATEMENT, BREAK_STATEMENT, RETURN_STATEMENT, WITH_STATEMENT, SWITCH_STATEMENT, THROW_STATEMENT, TRY_STATEMENT, DEBUGGER_STATEMENT));
        b.rule(BLOCK).is(EcmaScriptPunctuator.LCURLYBRACE, b.optional(STATEMENT_LIST), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(STATEMENT_LIST).is(b.oneOrMore(b.firstOf(STATEMENT, EcmaScriptGrammar.permissive(FUNCTION_DECLARATION))));
        b.rule(VARIABLE_STATEMENT).is(EcmaScriptKeyword.VAR, VARIABLE_DECLARATION_LIST, EOS);
        b.rule(VARIABLE_DECLARATION_LIST).is(VARIABLE_DECLARATION, b.zeroOrMore(EcmaScriptPunctuator.COMMA, VARIABLE_DECLARATION));
        b.rule(VARIABLE_DECLARATION_LIST_NO_IN).is(VARIABLE_DECLARATION_NO_IN, b.zeroOrMore(EcmaScriptPunctuator.COMMA, VARIABLE_DECLARATION_NO_IN));
        b.rule(VARIABLE_DECLARATION).is(EcmaScriptTokenType.IDENTIFIER, b.optional(INITIALISER));
        b.rule(VARIABLE_DECLARATION_NO_IN).is(EcmaScriptTokenType.IDENTIFIER, b.optional(INITIALISER_NO_IN));
        b.rule(INITIALISER).is(EcmaScriptPunctuator.EQU, ASSIGNMENT_EXPRESSION);
        b.rule(INITIALISER_NO_IN).is(EcmaScriptPunctuator.EQU, ASSIGNMENT_EXPRESSION_NO_IN);
        b.rule(EMPTY_STATEMENT).is(EcmaScriptPunctuator.SEMI);
        b.rule(EXPRESSION_STATEMENT).is(b.nextNot(b.firstOf(EcmaScriptPunctuator.LCURLYBRACE, EcmaScriptKeyword.FUNCTION)), EXPRESSION, EOS);
        b.rule(CONDITION).is(EXPRESSION);
        b.rule(IF_STATEMENT).is(EcmaScriptKeyword.IF, EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT, b.optional(ELSE_CLAUSE));
        b.rule(ELSE_CLAUSE).is(EcmaScriptKeyword.ELSE, STATEMENT);
        b.rule(ITERATION_STATEMENT).is(b.firstOf(DO_WHILE_STATEMENT, WHILE_STATEMENT, FOR_IN_STATEMENT, FOR_STATEMENT));
        b.rule(DO_WHILE_STATEMENT).is(EcmaScriptKeyword.DO, STATEMENT, EcmaScriptKeyword.WHILE, EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, EOS);
        b.rule(WHILE_STATEMENT).is(EcmaScriptKeyword.WHILE, EcmaScriptPunctuator.LPARENTHESIS, CONDITION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT);
        b.rule(FOR_IN_STATEMENT).is(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence(EcmaScriptKeyword.VAR, VARIABLE_DECLARATION_LIST_NO_IN), LEFT_HAND_SIDE_EXPRESSION), EcmaScriptKeyword.IN, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT);
        b.rule(FOR_STATEMENT).is(EcmaScriptKeyword.FOR, EcmaScriptPunctuator.LPARENTHESIS, b.firstOf(b.sequence(EcmaScriptKeyword.VAR, VARIABLE_DECLARATION_LIST_NO_IN), b.optional(EXPRESSION_NO_IN)), EcmaScriptPunctuator.SEMI, b.optional(CONDITION), EcmaScriptPunctuator.SEMI, b.optional(EXPRESSION), EcmaScriptPunctuator.RPARENTHESIS, STATEMENT);
        b.rule(CONTINUE_STATEMENT).is(EcmaScriptKeyword.CONTINUE, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptTokenType.IDENTIFIER, EOS), EOS_NO_LB));
        b.rule(BREAK_STATEMENT).is(EcmaScriptKeyword.BREAK, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, EcmaScriptTokenType.IDENTIFIER, EOS), EOS_NO_LB));
        b.rule(RETURN_STATEMENT).is(EcmaScriptKeyword.RETURN, b.firstOf(b.sequence(SPACING_NO_LB, NEXT_NOT_LB, EXPRESSION, EOS), EOS_NO_LB));
        b.rule(WITH_STATEMENT).is(EcmaScriptKeyword.WITH, EcmaScriptPunctuator.LPARENTHESIS, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, STATEMENT);
        b.rule(SWITCH_STATEMENT).is(EcmaScriptKeyword.SWITCH, EcmaScriptPunctuator.LPARENTHESIS, EXPRESSION, EcmaScriptPunctuator.RPARENTHESIS, CASE_BLOCK);
        b.rule(CASE_BLOCK).is(EcmaScriptPunctuator.LCURLYBRACE, b.optional(CASE_CLAUSES), b.optional(DEFAULT_CLAUSE, b.optional(CASE_CLAUSES)), EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(CASE_CLAUSES).is(b.oneOrMore(CASE_CLAUSE));
        b.rule(CASE_CLAUSE).is(EcmaScriptKeyword.CASE, EXPRESSION, EcmaScriptPunctuator.COLON, b.optional(STATEMENT_LIST));
        b.rule(DEFAULT_CLAUSE).is(EcmaScriptKeyword.DEFAULT, EcmaScriptPunctuator.COLON, b.optional(STATEMENT_LIST));
        b.rule(LABELLED_STATEMENT).is(EcmaScriptTokenType.IDENTIFIER, EcmaScriptPunctuator.COLON, STATEMENT);
        b.rule(THROW_STATEMENT).is(EcmaScriptKeyword.THROW, SPACING_NO_LB, NEXT_NOT_LB, EXPRESSION, EOS);
        b.rule(TRY_STATEMENT).is(EcmaScriptKeyword.TRY, BLOCK, b.firstOf(b.sequence(CATCH, b.optional(FINALLY)), FINALLY));
        b.rule(CATCH).is(EcmaScriptKeyword.CATCH, EcmaScriptPunctuator.LPARENTHESIS, EcmaScriptTokenType.IDENTIFIER, EcmaScriptPunctuator.RPARENTHESIS, BLOCK);
        b.rule(FINALLY).is(EcmaScriptKeyword.FINALLY, BLOCK);
        b.rule(DEBUGGER_STATEMENT).is(EcmaScriptKeyword.DEBUGGER, EOS);
    }

    private static void functionsAndPrograms(LexerlessGrammarBuilder b) {
        b.rule(FUNCTION_DECLARATION).is(EcmaScriptKeyword.FUNCTION, EcmaScriptTokenType.IDENTIFIER, EcmaScriptPunctuator.LPARENTHESIS, b.optional(FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(FUNCTION_EXPRESSION).is(EcmaScriptKeyword.FUNCTION, b.optional(EcmaScriptTokenType.IDENTIFIER), EcmaScriptPunctuator.LPARENTHESIS, b.optional(FORMAL_PARAMETER_LIST), EcmaScriptPunctuator.RPARENTHESIS, EcmaScriptPunctuator.LCURLYBRACE, FUNCTION_BODY, EcmaScriptPunctuator.RCURLYBRACE);
        b.rule(FORMAL_PARAMETER_LIST).is(EcmaScriptTokenType.IDENTIFIER, b.zeroOrMore(EcmaScriptPunctuator.COMMA, EcmaScriptTokenType.IDENTIFIER));
        b.rule(FUNCTION_BODY).is(b.optional(SOURCE_ELEMENTS));
        b.rule(PROGRAM).is(b.optional(SHEBANG), b.optional(SOURCE_ELEMENTS), SPACING, EOF);
        b.rule(SOURCE_ELEMENTS).is(b.oneOrMore(SOURCE_ELEMENT));
        b.rule(SOURCE_ELEMENT).is(b.firstOf(STATEMENT, FUNCTION_DECLARATION));
        b.rule(SHEBANG).is("#!", b.regexp("[^\\n\\r]*+")).skip();
    }

    private static Object permissive(Object object) {
        return object;
    }

    private EcmaScriptGrammar() {
        String name = this.name();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) == '_' && i + 1 < name.length()) {
                sb.append(name.charAt(++i));
                continue;
            }
            sb.append(Character.toLowerCase(name.charAt(i)));
        }
        this.internalName = sb.toString();
    }

    public String toString() {
        return this.internalName;
    }
}

