/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.sslr.parser;

import com.google.common.base.Preconditions;
import java.util.List;
import org.sonar.sslr.internal.matchers.InputBuffer;
import org.sonar.sslr.internal.matchers.MatcherPathElement;

public class ParseError {
    private final InputBuffer inputBuffer;
    private final int errorIndex;
    private final String message;
    private final List<List<MatcherPathElement>> failedPaths;

    public ParseError(InputBuffer inputBuffer, int errorIndex, String message, List<List<MatcherPathElement>> failedPaths) {
        this.inputBuffer = Preconditions.checkNotNull(inputBuffer, "inputBuffer");
        this.errorIndex = errorIndex;
        this.message = Preconditions.checkNotNull(message, "message");
        Preconditions.checkNotNull(failedPaths, "failedPaths");
        Preconditions.checkArgument(!failedPaths.isEmpty(), "failedPaths must contain at least one element");
        this.failedPaths = failedPaths;
    }

    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    public int getErrorIndex() {
        return this.errorIndex;
    }

    public String getMessage() {
        return this.message;
    }

    public List<List<MatcherPathElement>> getFailedPaths() {
        return this.failedPaths;
    }
}

