/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript;

import com.google.common.base.Charsets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.impl.Parser;
import java.io.File;
import java.util.Collection;
import org.sonar.javascript.CharsetAwareVisitor;
import org.sonar.javascript.EcmaScriptCommentAnalyser;
import org.sonar.javascript.EcmaScriptConfiguration;
import org.sonar.javascript.ProgressAstScanner;
import org.sonar.javascript.api.EcmaScriptMetric;
import org.sonar.javascript.api.EcmaScriptTokenType;
import org.sonar.javascript.metrics.ComplexityVisitor;
import org.sonar.javascript.metrics.LinesOfCodeVisitor;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.parser.EcmaScriptGrammar;
import org.sonar.javascript.parser.EcmaScriptParser;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.SourceCodeBuilderCallback;
import org.sonar.squidbridge.SourceCodeBuilderVisitor;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.SquidAstVisitorContextImpl;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.api.SourceProject;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.metrics.CommentsVisitor;
import org.sonar.squidbridge.metrics.CounterVisitor;
import org.sonar.squidbridge.metrics.LinesVisitor;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

public final class JavaScriptAstScanner {
    private static final GrammarRuleKey[] FUNCTION_NODES = new GrammarRuleKey[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_DECLARATION};

    private JavaScriptAstScanner() {
    }

    public static SourceFile scanSingleFile(File file, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        if (!file.isFile()) {
            throw new IllegalArgumentException("File '" + file + "' not found.");
        }
        AstScanner<LexerlessGrammar> scanner = JavaScriptAstScanner.create(new EcmaScriptConfiguration(Charsets.UTF_8), visitors);
        scanner.scanFile(file);
        Collection<SourceCode> sources = scanner.getIndex().search(new QueryByType(SourceFile.class));
        if (sources.size() != 1) {
            throw new IllegalStateException("Only one SourceFile was expected whereas " + sources.size() + " has been returned.");
        }
        return (SourceFile)sources.iterator().next();
    }

    public static AstScanner<LexerlessGrammar> create(EcmaScriptConfiguration conf, SquidAstVisitor<LexerlessGrammar> ... visitors) {
        SquidAstVisitorContextImpl<LexerlessGrammar> context = new SquidAstVisitorContextImpl<LexerlessGrammar>(new SourceProject("JavaScript Project"));
        Parser<LexerlessGrammar> parser = EcmaScriptParser.create(conf);
        AstScanner.Builder<LexerlessGrammar> builder = new ProgressAstScanner.Builder(context).setBaseParser(parser);
        builder.withMetrics(EcmaScriptMetric.values());
        builder.setCommentAnalyser(new EcmaScriptCommentAnalyser());
        builder.setFilesMetric(EcmaScriptMetric.FILES);
        builder.withSquidAstVisitor(new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){
            private int seq = 0;

            @Override
            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                ++this.seq;
                SourceClass cls = new SourceClass("class:" + this.seq);
                cls.setStartAtLine(astNode.getTokenLine());
                return cls;
            }
        }, Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION));
        builder.withSquidAstVisitor(CounterVisitor.builder().setMetricDef(EcmaScriptMetric.CLASSES).subscribeTo(Tree.Kind.CLASS_DECLARATION, Tree.Kind.CLASS_EXPRESSION).build());
        builder.withSquidAstVisitor(CounterVisitor.builder().setMetricDef(EcmaScriptMetric.FUNCTIONS).subscribeTo(FUNCTION_NODES).build());
        builder.withSquidAstVisitor(new SourceCodeBuilderVisitor(new SourceCodeBuilderCallback(){

            @Override
            public SourceCode createSourceCode(SourceCode parentSourceCode, AstNode astNode) {
                AstNode identifier = astNode.getFirstChild(EcmaScriptTokenType.IDENTIFIER, EcmaScriptGrammar.PROPERTY_NAME, Tree.Kind.IDENTIFIER);
                String functionName = identifier == null ? "anonymous" : identifier.getTokenValue();
                String fileKey = parentSourceCode.isType(SourceFile.class) ? parentSourceCode.getKey() : parentSourceCode.getParent(SourceFile.class).getKey();
                SourceFunction function = new SourceFunction(fileKey + ":" + functionName + ":" + astNode.getToken().getLine() + ":" + astNode.getToken().getColumn());
                function.setStartAtLine(astNode.getTokenLine());
                return function;
            }
        }, FUNCTION_NODES));
        builder.withSquidAstVisitor(new LinesVisitor(EcmaScriptMetric.LINES));
        builder.withSquidAstVisitor(new LinesOfCodeVisitor(EcmaScriptMetric.LINES_OF_CODE));
        builder.withSquidAstVisitor(CommentsVisitor.builder().withCommentMetric(EcmaScriptMetric.COMMENT_LINES).withNoSonar(true).withIgnoreHeaderComment(conf.getIgnoreHeaderComments()).build());
        builder.withSquidAstVisitor(CounterVisitor.builder().setMetricDef(EcmaScriptMetric.STATEMENTS).subscribeTo(Tree.Kind.VARIABLE_STATEMENT, Tree.Kind.EMPTY_STATEMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.IF_STATEMENT, Tree.Kind.DO_WHILE_STATEMENT, Tree.Kind.WHILE_STATEMENT, Tree.Kind.FOR_IN_STATEMENT, Tree.Kind.FOR_OF_STATEMENT, Tree.Kind.FOR_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.WITH_STATEMENT, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.THROW_STATEMENT, Tree.Kind.TRY_STATEMENT, Tree.Kind.DEBUGGER_STATEMENT).build());
        builder.withSquidAstVisitor(CounterVisitor.builder().setMetricDef(EcmaScriptMetric.ACCESSORS).subscribeTo(Tree.Kind.GET_METHOD, Tree.Kind.SET_METHOD).build());
        builder.withSquidAstVisitor(new ComplexityVisitor());
        for (SquidAstVisitor<LexerlessGrammar> visitor : visitors) {
            if (visitor instanceof CharsetAwareVisitor) {
                ((CharsetAwareVisitor)((Object)visitor)).setCharset(conf.getCharset());
            }
            builder.withSquidAstVisitor(visitor);
        }
        return builder.build();
    }
}

