/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript;

import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.sonar.javascript.ProgressReport;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.SquidAstVisitorContextImpl;
import org.sonar.sslr.parser.LexerlessGrammar;

public class ProgressAstScanner
extends AstScanner<LexerlessGrammar> {
    private final ProgressReport progressReport;

    protected ProgressAstScanner(Builder builder) {
        super(builder);
        this.progressReport = builder.progressReport;
    }

    @Override
    public void scanFiles(Collection<File> files) {
        this.progressReport.start(files.size());
        super.scanFiles(files);
        this.progressReport.stop();
    }

    public static class Builder
    extends AstScanner.Builder<LexerlessGrammar> {
        private final ProgressReport progressReport = new ProgressReport("Report about progress of ActionScript analyzer", TimeUnit.SECONDS.toMillis(10L));

        public Builder(SquidAstVisitorContextImpl<LexerlessGrammar> context) {
            super(context);
        }

        @Override
        public AstScanner<LexerlessGrammar> build() {
            super.withSquidAstVisitor(new SquidAstVisitor<LexerlessGrammar>(){

                @Override
                public void visitFile(@Nullable AstNode astNode) {
                    Builder.this.progressReport.nextFile(this.getContext().getFile());
                }
            });
            return new ProgressAstScanner(this);
        }
    }
}

