/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.metrics;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.GenericTokenType;
import com.sonar.sslr.api.Token;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.measures.MetricDef;
import org.sonar.sslr.parser.LexerlessGrammar;

public class LinesOfCodeVisitor
extends SquidAstVisitor<LexerlessGrammar>
implements AstAndTokenVisitor {
    private final MetricDef metric;
    private Set<Integer> lines = Sets.newHashSet();

    public LinesOfCodeVisitor(MetricDef metric) {
        this.metric = metric;
    }

    @Override
    public void visitFile(AstNode node) {
        this.lines.clear();
    }

    @Override
    public void visitToken(Token token) {
        if (token.getType() != GenericTokenType.EOF) {
            this.lines.add(token.getLine());
        }
    }

    @Override
    public void leaveFile(@Nullable AstNode astNode) {
        this.getContext().peekSourceCode().add(this.metric, this.lines.size());
    }
}

