/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.declaration;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.BindingElementTree;
import org.sonar.javascript.model.interfaces.declaration.BindingPropertyTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class BindingPropertyTreeImpl
extends JavaScriptTree
implements BindingPropertyTree {
    private final ExpressionTree name;
    private final SyntaxToken colonToken;
    private final BindingElementTree value;

    public BindingPropertyTreeImpl(ExpressionTree name, InternalSyntaxToken colonToken, BindingElementTree value) {
        super(Tree.Kind.BINDING_PROPERTY);
        this.name = name;
        this.colonToken = colonToken;
        this.value = value;
        this.addChildren((AstNode)((Object)name), colonToken, (AstNode)((Object)value));
    }

    @Override
    public ExpressionTree name() {
        return this.name;
    }

    @Override
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public BindingElementTree value() {
        return this.value;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BINDING_PROPERTY;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.name, this.value);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBindingProperty(this);
    }
}

