/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.declaration;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.declaration.ParameterListTreeImpl;
import org.sonar.javascript.model.implementations.expression.IdentifierTreeImpl;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.implementations.statement.BlockTreeImpl;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.FunctionDeclarationTree;
import org.sonar.javascript.model.interfaces.declaration.ParameterListTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.BlockTree;

public class FunctionDeclarationTreeImpl
extends JavaScriptTree
implements FunctionDeclarationTree {
    private final SyntaxToken functionKeyword;
    private final SyntaxToken starToken;
    private final IdentifierTree name;
    private final ParameterListTree parameters;
    private final BlockTree body;
    private final Tree.Kind kind;

    public FunctionDeclarationTreeImpl(InternalSyntaxToken functionKeyword, InternalSyntaxToken starToken, IdentifierTreeImpl name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        super(Tree.Kind.GENERATOR_DECLARATION);
        this.functionKeyword = functionKeyword;
        this.starToken = starToken;
        this.name = name;
        this.parameters = parameters;
        this.body = body;
        this.kind = Tree.Kind.GENERATOR_DECLARATION;
        this.addChildren(functionKeyword, starToken, name, parameters, body);
    }

    public FunctionDeclarationTreeImpl(InternalSyntaxToken functionKeyword, IdentifierTreeImpl name, ParameterListTreeImpl parameters, BlockTreeImpl body) {
        super(Tree.Kind.FUNCTION_DECLARATION);
        this.functionKeyword = functionKeyword;
        this.starToken = null;
        this.name = name;
        this.parameters = parameters;
        this.body = body;
        this.kind = Tree.Kind.FUNCTION_DECLARATION;
        this.addChildren(functionKeyword, name, parameters, body);
    }

    @Override
    public SyntaxToken functionKeyword() {
        return this.functionKeyword;
    }

    @Override
    @Nullable
    public SyntaxToken starToken() {
        return this.starToken;
    }

    @Override
    public IdentifierTree name() {
        return this.name;
    }

    @Override
    public ParameterListTree parameters() {
        return this.parameters;
    }

    @Override
    public BlockTree body() {
        return this.body;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.name, this.parameters, this.body);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitFunctionDeclaration(this);
    }
}

