/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.declaration;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.model.implementations.declaration.ObjectBindingPatternTreeImpl;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.BindingElementTree;
import org.sonar.javascript.model.interfaces.declaration.InitializedBindingElementTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class InitializedBindingElementTreeImpl
extends JavaScriptTree
implements InitializedBindingElementTree {
    private BindingElementTree left;
    private final SyntaxToken equalToken;
    private final ExpressionTree right;

    public InitializedBindingElementTreeImpl(InternalSyntaxToken equalToken, ExpressionTree right) {
        super(Tree.Kind.INITIALIZED_BINDING_ELEMENT);
        this.equalToken = equalToken;
        this.right = right;
        this.addChildren(equalToken, (AstNode)((Object)right));
    }

    public InitializedBindingElementTreeImpl completeWithLeft(BindingElementTree left) {
        this.left = left;
        this.prependChildren((AstNode)((Object)left));
        return this;
    }

    @Override
    public BindingElementTree left() {
        return this.left;
    }

    @Override
    public SyntaxToken equalToken() {
        return this.equalToken;
    }

    @Override
    public ExpressionTree right() {
        return this.right;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.left, this.right);
    }

    @Override
    public AstNodeType getKind() {
        return Tree.Kind.INITIALIZED_BINDING_ELEMENT;
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitInitializedBindingElement(this);
    }

    public List<IdentifierTree> bindingIdentifiers() {
        ArrayList<IdentifierTree> bindingIdentifiers = Lists.newArrayList();
        if (this.left.is(Tree.Kind.BINDING_IDENTIFIER)) {
            return Lists.newArrayList((IdentifierTree)this.left);
        }
        if (this.left.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
            bindingIdentifiers.addAll(((ObjectBindingPatternTreeImpl)this.left).bindingIdentifiers());
        } else {
            bindingIdentifiers.addAll(((ArrayBindingPatternTreeImpl)this.left).bindingIdentifiers());
        }
        return bindingIdentifiers;
    }
}

