/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.expression;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.SeparatedList;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ArrayLiteralTree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;

public class ArrayLiteralTreeImpl
extends JavaScriptTree
implements ArrayLiteralTree {
    private SyntaxToken openBracket;
    private final SeparatedList<ExpressionTree> elements;
    private SyntaxToken closeBracket;

    public ArrayLiteralTreeImpl(InternalSyntaxToken openBracket, InternalSyntaxToken closeBracket) {
        super(Tree.Kind.ARRAY_LITERAL);
        this.openBracket = openBracket;
        this.elements = new SeparatedList(ListUtils.EMPTY_LIST, ListUtils.EMPTY_LIST);
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, closeBracket);
    }

    public ArrayLiteralTreeImpl(List<ExpressionTree> elements, List<InternalSyntaxToken> commas, List<AstNode> children) {
        super(Tree.Kind.ARRAY_LITERAL);
        this.elements = new SeparatedList<ExpressionTree>(elements, commas);
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    public ArrayLiteralTreeImpl complete(InternalSyntaxToken openBracket, InternalSyntaxToken closeBracket) {
        this.openBracket = openBracket;
        this.closeBracket = closeBracket;
        this.prependChildren(openBracket);
        this.addChild(closeBracket);
        return this;
    }

    @Override
    public SyntaxToken openBracket() {
        return this.openBracket;
    }

    @Override
    public SeparatedList<ExpressionTree> elements() {
        return this.elements;
    }

    @Override
    public SyntaxToken closeBracket() {
        return this.closeBracket;
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.ARRAY_LITERAL;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(new Iterator[]{this.elements.iterator()});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitArrayLiteral(this);
    }
}

