/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.ListUtils;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.BlockTree;
import org.sonar.javascript.model.interfaces.statement.StatementTree;

public class BlockTreeImpl
extends JavaScriptTree
implements BlockTree {
    private final SyntaxToken openCurlyBrace;
    private final List<StatementTree> statements;
    private final SyntaxToken closeCurlyBrace;

    public BlockTreeImpl(InternalSyntaxToken openCurlyBrace, List<StatementTree> statements, InternalSyntaxToken closeCurlyBrace) {
        super(Tree.Kind.BLOCK);
        this.openCurlyBrace = openCurlyBrace;
        this.statements = statements;
        this.closeCurlyBrace = closeCurlyBrace;
        this.addChild(openCurlyBrace);
        for (StatementTree child : statements) {
            this.addChild((AstNode)((Object)child));
        }
        this.addChild(closeCurlyBrace);
    }

    public BlockTreeImpl(InternalSyntaxToken openCurlyBrace, InternalSyntaxToken closeCurlyBrace) {
        super(Tree.Kind.BLOCK);
        this.openCurlyBrace = openCurlyBrace;
        this.statements = ListUtils.EMPTY_LIST;
        this.closeCurlyBrace = closeCurlyBrace;
        this.addChild(openCurlyBrace);
        this.addChild(closeCurlyBrace);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BLOCK;
    }

    @Override
    public SyntaxToken openCurlyBrace() {
        return this.openCurlyBrace;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    public SyntaxToken closeCurlyBrace() {
        return this.closeCurlyBrace;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(new Iterator[]{this.statements.iterator()});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitBlock(this);
    }
}

