/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.SeparatedList;
import org.sonar.javascript.model.implementations.declaration.ArrayBindingPatternTreeImpl;
import org.sonar.javascript.model.implementations.declaration.InitializedBindingElementTreeImpl;
import org.sonar.javascript.model.implementations.declaration.ObjectBindingPatternTreeImpl;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.declaration.BindingElementTree;
import org.sonar.javascript.model.interfaces.expression.IdentifierTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.VariableDeclarationTree;

public class VariableDeclarationTreeImpl
extends JavaScriptTree
implements VariableDeclarationTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken token;
    private final SeparatedList<BindingElementTree> variables;

    public VariableDeclarationTreeImpl(Tree.Kind kind, InternalSyntaxToken token, SeparatedList<BindingElementTree> variables, List<AstNode> children) {
        super(kind);
        this.kind = kind;
        this.token = token;
        this.variables = variables;
        this.addChild(token);
        for (AstNode child : children) {
            this.addChild(child);
        }
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public SyntaxToken token() {
        return this.token;
    }

    @Override
    public SeparatedList<BindingElementTree> variables() {
        return this.variables;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.concat(new Iterator[]{this.variables.iterator()});
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitVariableDeclaration(this);
    }

    public List<IdentifierTree> variableIdentifiers() {
        ArrayList<IdentifierTree> identifiers = Lists.newArrayList();
        for (Tree tree : this.variables) {
            if (tree.is(Tree.Kind.BINDING_IDENTIFIER)) {
                identifiers.add((IdentifierTree)tree);
                continue;
            }
            if (tree.is(Tree.Kind.INITIALIZED_BINDING_ELEMENT)) {
                identifiers.addAll(((InitializedBindingElementTreeImpl)tree).bindingIdentifiers());
                continue;
            }
            if (tree.is(Tree.Kind.OBJECT_BINDING_PATTERN)) {
                identifiers.addAll(((ObjectBindingPatternTreeImpl)tree).bindingIdentifiers());
                continue;
            }
            identifiers.addAll(((ArrayBindingPatternTreeImpl)tree).bindingIdentifiers());
        }
        return identifiers;
    }
}

