/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.model.implementations.statement;

import com.google.common.collect.Iterators;
import com.sonar.sslr.api.AstNode;
import java.util.Iterator;
import org.sonar.javascript.ast.visitors.TreeVisitor;
import org.sonar.javascript.model.implementations.JavaScriptTree;
import org.sonar.javascript.model.implementations.lexical.InternalSyntaxToken;
import org.sonar.javascript.model.interfaces.Tree;
import org.sonar.javascript.model.interfaces.expression.ExpressionTree;
import org.sonar.javascript.model.interfaces.lexical.SyntaxToken;
import org.sonar.javascript.model.interfaces.statement.StatementTree;
import org.sonar.javascript.model.interfaces.statement.WithStatementTree;

public class WithStatementTreeImpl
extends JavaScriptTree
implements WithStatementTree {
    private final SyntaxToken withKeyword;
    private final SyntaxToken openingParenthesis;
    private final ExpressionTree expression;
    private final SyntaxToken closingParenthesis;
    private final StatementTree statement;

    public WithStatementTreeImpl(InternalSyntaxToken withKeyword, InternalSyntaxToken openingParenthesis, ExpressionTree expression, InternalSyntaxToken closingParenthesis, StatementTree statement) {
        super(Tree.Kind.WITH_STATEMENT);
        this.withKeyword = withKeyword;
        this.openingParenthesis = openingParenthesis;
        this.expression = expression;
        this.closingParenthesis = closingParenthesis;
        this.statement = statement;
        this.addChild(withKeyword);
        this.addChild(openingParenthesis);
        this.addChild((AstNode)((Object)expression));
        this.addChild(closingParenthesis);
        this.addChild((AstNode)((Object)statement));
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.WITH_STATEMENT;
    }

    @Override
    public SyntaxToken withKeyword() {
        return this.withKeyword;
    }

    @Override
    public SyntaxToken openingParenthesis() {
        return this.openingParenthesis;
    }

    @Override
    public Tree expression() {
        return this.expression;
    }

    @Override
    public SyntaxToken closingParenthesis() {
        return this.closingParenthesis;
    }

    @Override
    public StatementTree statement() {
        return this.statement;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray(this.expression, this.statement);
    }

    @Override
    public void accept(TreeVisitor visitor) {
        visitor.visitWithStatement(this);
    }
}

