/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.squidbridge.commonrules.internal.checks;

import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.MeasureUtils;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.SqaleLinearRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.commonrules.internal.checks.CommonCheck;

@Rule(key="FailedUnitTests", name="Failed unit tests should be fixed", priority=Priority.MAJOR, tags={"bug"}, description="<p>Test failures or errors generally indicate that regressions have been introduced. Those tests should be handled as soon as possible to reduce the cost to fix the corresponding regressions.</p>")
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleLinearRemediation(coeff="10min", effortToFixDescription="number of failed tests")
public class FailedUnitTestsCheck
extends CommonCheck {
    @Override
    public void checkResource(Resource resource, DecoratorContext context, RuleKey ruleKey, ResourcePerspectives perspectives) {
        double testErrors = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.TEST_ERRORS), (Double)0.0);
        double testFailures = MeasureUtils.getValue((Measure)context.getMeasure(CoreMetrics.TEST_FAILURES), (Double)0.0);
        double testFailuresAndErrors = testErrors + testFailures;
        if (ResourceUtils.isUnitTestClass((Resource)resource) && testFailuresAndErrors > 0.0) {
            this.createIssue(resource, ruleKey, testFailuresAndErrors, perspectives);
        }
    }

    private void createIssue(Resource resource, RuleKey ruleKey, double testFailuresAndErrors, ResourcePerspectives perspectives) {
        String fileName = resource.getName();
        this.createIssue(resource, perspectives, ruleKey, testFailuresAndErrors, "Fix failing unit tests on file \"" + fileName + "\".");
    }
}

