/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.Grammar;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.issue.Issuable;
import org.sonar.api.issue.Issue;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.FileLinesContextFactory;
import org.sonar.api.measures.PersistenceMode;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rules.ActiveRule;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.php.PHPAstScanner;
import org.sonar.php.PHPConfiguration;
import org.sonar.php.api.PHPMetric;
import org.sonar.php.checks.CheckList;
import org.sonar.php.metrics.FileLinesVisitor;
import org.sonar.squidbridge.AstScanner;
import org.sonar.squidbridge.SquidAstVisitor;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.Query;
import org.sonar.squidbridge.api.SourceClass;
import org.sonar.squidbridge.api.SourceCode;
import org.sonar.squidbridge.api.SourceFile;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.indexer.QueryByParent;
import org.sonar.squidbridge.indexer.QueryByType;
import org.sonar.squidbridge.measures.MetricDef;

public class PHPSquidSensor
implements Sensor {
    private static final Number[] FUNCTIONS_DISTRIB_BOTTOM_LIMITS = new Number[]{1, 2, 4, 6, 8, 10, 12};
    private static final Number[] FILES_DISTRIB_BOTTOM_LIMITS = new Number[]{0, 5, 10, 20, 30, 60, 90};
    private final AnnotationCheckFactory annotationCheckFactory;
    private final ResourcePerspectives resourcePerspectives;
    private final ModuleFileSystem fileSystem;
    private final FileLinesContextFactory fileLinesContextFactory;
    private AstScanner<Grammar> scanner;
    private SensorContext context;
    private Project project;

    public PHPSquidSensor(RulesProfile profile, ResourcePerspectives resourcePerspectives, ModuleFileSystem filesystem, FileLinesContextFactory fileLinesContextFactory) {
        this.annotationCheckFactory = AnnotationCheckFactory.create((RulesProfile)profile, (String)"php", (Collection)CheckList.getChecks());
        this.resourcePerspectives = resourcePerspectives;
        this.fileLinesContextFactory = fileLinesContextFactory;
        this.fileSystem = filesystem;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"php"})).isEmpty();
    }

    public void analyse(Project project, SensorContext context) {
        this.context = context;
        this.project = project;
        List<SquidAstVisitor<Grammar>> visitors = this.getCheckVisitors();
        visitors.add((SquidAstVisitor<Grammar>)new FileLinesVisitor(project, this.fileLinesContextFactory));
        this.scanner = PHPAstScanner.create((PHPConfiguration)this.createConfiguration(), (SquidAstVisitor[])visitors.toArray(new SquidAstVisitor[visitors.size()]));
        this.scanner.scanFiles(this.getProjectMainFiles());
        this.save(this.scanner.getIndex().search(new Query[]{new QueryByType(SourceFile.class)}));
    }

    @VisibleForTesting
    org.sonar.api.resources.File getSonarResource(File file) {
        return org.sonar.api.resources.File.fromIOFile((File)file, (Project)this.project);
    }

    private void save(Collection<SourceCode> squidSourceFiles) {
        for (SourceCode squidSourceFile : squidSourceFiles) {
            SourceFile squidFile = (SourceFile)squidSourceFile;
            org.sonar.api.resources.File sonarFile = this.getSonarResource(new File(squidFile.getKey()));
            this.saveClassComplexity(sonarFile, squidFile);
            this.saveFilesComplexityDistribution(sonarFile, squidFile);
            this.saveFunctionsComplexityDistribution(sonarFile, squidFile);
            this.saveFileMeasures(sonarFile, squidFile);
            this.saveViolations(sonarFile, squidFile);
        }
    }

    private void saveFileMeasures(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FILES, Double.valueOf(squidFile.getDouble((MetricDef)PHPMetric.FILES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.LINES, Double.valueOf(squidFile.getDouble((MetricDef)PHPMetric.LINES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.NCLOC, Double.valueOf(squidFile.getDouble((MetricDef)PHPMetric.LINES_OF_CODE)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMMENT_LINES, Double.valueOf(squidFile.getDouble((MetricDef)PHPMetric.COMMENT_LINES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.CLASSES, Double.valueOf(squidFile.getDouble((MetricDef)PHPMetric.CLASSES)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.FUNCTIONS, Double.valueOf(squidFile.getDouble((MetricDef)PHPMetric.FUNCTIONS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.STATEMENTS, Double.valueOf(squidFile.getDouble((MetricDef)PHPMetric.STATEMENTS)));
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY, Double.valueOf(squidFile.getDouble((MetricDef)PHPMetric.COMPLEXITY)));
    }

    private void saveClassComplexity(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Collection classes = this.scanner.getIndex().search(new Query[]{new QueryByParent((SourceCode)squidFile), new QueryByType(SourceClass.class)});
        double complexityInClasses = 0.0;
        for (SourceCode squidClass : classes) {
            double classComplexity = squidClass.getDouble((MetricDef)PHPMetric.COMPLEXITY);
            complexityInClasses += classComplexity;
        }
        this.context.saveMeasure((Resource)sonarFile, CoreMetrics.COMPLEXITY_IN_CLASSES, Double.valueOf(complexityInClasses));
    }

    private void saveFunctionsComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Collection squidFunctionsInFile = this.scanner.getIndex().search(new Query[]{new QueryByParent((SourceCode)squidFile), new QueryByType(SourceFunction.class)});
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, FUNCTIONS_DISTRIB_BOTTOM_LIMITS);
        for (SourceCode squidFunction : squidFunctionsInFile) {
            complexityDistribution.add((Number)squidFunction.getDouble((MetricDef)PHPMetric.COMPLEXITY));
        }
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveFilesComplexityDistribution(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        RangeDistributionBuilder complexityDistribution = new RangeDistributionBuilder(CoreMetrics.FILE_COMPLEXITY_DISTRIBUTION, FILES_DISTRIB_BOTTOM_LIMITS);
        complexityDistribution.add((Number)squidFile.getDouble((MetricDef)PHPMetric.COMPLEXITY));
        this.context.saveMeasure((Resource)sonarFile, complexityDistribution.build().setPersistenceMode(PersistenceMode.MEMORY));
    }

    private void saveViolations(org.sonar.api.resources.File sonarFile, SourceFile squidFile) {
        Set messages = squidFile.getCheckMessages();
        if (messages != null) {
            for (CheckMessage message : messages) {
                ActiveRule rule = this.annotationCheckFactory.getActiveRule(message.getCheck());
                Issuable issuable = (Issuable)this.resourcePerspectives.as(Issuable.class, (Resource)sonarFile);
                if (issuable == null) continue;
                Issue issue = issuable.newIssueBuilder().ruleKey(RuleKey.of((String)rule.getRepositoryKey(), (String)rule.getRuleKey())).line(message.getLine()).message(message.getText(Locale.ENGLISH)).build();
                issuable.addIssue(issue);
            }
        }
    }

    private PHPConfiguration createConfiguration() {
        return new PHPConfiguration(this.fileSystem.sourceCharset());
    }

    private Collection<File> getProjectMainFiles() {
        return this.fileSystem.files(FileQuery.onSource().onLanguage(new String[]{"php"}));
    }

    private List<SquidAstVisitor<Grammar>> getCheckVisitors() {
        return Lists.newArrayList((Iterable)this.annotationCheckFactory.getChecks());
    }
}

