/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.api;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.resources.AbstractLanguage;

public final class Php
extends AbstractLanguage {
    public static final String NAME = "PHP";
    public static final String KEY = "php";
    public static final String DEFAULT_FILE_SUFFIXES = "php,php3,php4,php5,phtml,inc";
    private Settings settings;

    public Php(Settings settings) {
        super(KEY, NAME);
        this.settings = settings;
    }

    public Php() {
        this(new Settings());
    }

    public String[] getFileSuffixes() {
        String[] suffixes = this.filterEmptyStrings(this.settings.getStringArray("sonar.php.file.suffixes"));
        if (suffixes.length == 0) {
            suffixes = StringUtils.split((String)DEFAULT_FILE_SUFFIXES, (String)",");
        }
        return suffixes;
    }

    private String[] filterEmptyStrings(String[] stringArray) {
        ArrayList nonEmptyStrings = Lists.newArrayList();
        for (String string : stringArray) {
            if (!StringUtils.isNotBlank((String)string.trim())) continue;
            nonEmptyStrings.add(string.trim());
        }
        return nonEmptyStrings.toArray(new String[nonEmptyStrings.size()]);
    }

    public boolean hasValidSuffixes(String fileName) {
        String pathLowerCase = StringUtils.lowerCase((String)fileName);
        for (String suffix : this.getFileSuffixes()) {
            if (!pathLowerCase.endsWith("." + StringUtils.lowerCase((String)suffix))) continue;
            return true;
        }
        return false;
    }
}

