/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.core;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.scan.filesystem.FileQuery;
import org.sonar.api.scan.filesystem.ModuleFileSystem;
import org.sonar.php.api.PHPKeyword;
import org.sonar.squidbridge.measures.Metric;
import org.sonar.squidbridge.recognizer.CamelCaseDetector;
import org.sonar.squidbridge.recognizer.ContainsDetector;
import org.sonar.squidbridge.recognizer.Detector;
import org.sonar.squidbridge.recognizer.EndWithDetector;
import org.sonar.squidbridge.recognizer.KeywordsDetector;
import org.sonar.squidbridge.recognizer.LanguageFootprint;
import org.sonar.squidbridge.text.Source;

@Phase(name=Phase.Name.PRE)
public class NoSonarAndCommentedOutLocSensor
implements Sensor {
    private static final double CODE_RECOGNIZER_SENSITIVITY = 0.9;
    private static final Logger LOG = LoggerFactory.getLogger(NoSonarAndCommentedOutLocSensor.class);
    private final NoSonarFilter filter;
    private final ModuleFileSystem filesystem;

    public NoSonarAndCommentedOutLocSensor(ModuleFileSystem filesystem, NoSonarFilter noSonarFilter) {
        this.filter = noSonarFilter;
        this.filesystem = filesystem;
    }

    public void analyse(Project project, SensorContext context) {
        List sourceFiles = this.filesystem.files(FileQuery.onSource().onLanguage(new String[]{"php"}));
        for (File file : sourceFiles) {
            Source source;
            org.sonar.api.resources.File phpFile = this.getSonarResource(project, file);
            if (phpFile == null || (source = NoSonarAndCommentedOutLocSensor.analyseSourceCode(file)) == null) continue;
            this.filter.addResource((Resource)phpFile, source.getNoSonarTagLines());
            double measure = source.getMeasure(Metric.COMMENTED_OUT_CODE_LINES);
            context.saveMeasure((Resource)phpFile, CoreMetrics.COMMENTED_OUT_CODE_LINES, Double.valueOf(measure));
        }
    }

    @VisibleForTesting
    org.sonar.api.resources.File getSonarResource(Project project, File file) {
        return org.sonar.api.resources.File.fromIOFile((File)file, (Project)project);
    }

    /*
     * Exception decompiling
     */
    protected static Source analyseSourceCode(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean shouldExecuteOnProject(Project project) {
        return !this.filesystem.files(FileQuery.onSource().onLanguage(new String[]{"php"})).isEmpty();
    }

    public String toString() {
        return "NoSonar and Commented out LOC Sensor";
    }

    private static class PhpLanguageFootprint
    implements LanguageFootprint {
        private static final double CAMEL_CASE_PROBABILITY = 0.5;
        private static final double CONDITIONAL_PROBABILITY = 0.95;
        private static final double PHP_KEYWORDS_PROBABILITY = 0.3;
        private static final double BOOLEAN_OPERATOR_PROBABILITY = 0.7;
        private static final double END_WITH_DETECTOR_PROBABILITY = 0.95;
        private final Set<Detector> detectors = new HashSet<Detector>();

        public PhpLanguageFootprint() {
            this.detectors.add((Detector)new EndWithDetector(0.95, new char[]{'}', ';', '{'}));
            this.detectors.add((Detector)new KeywordsDetector(0.7, new String[]{"||", "&&"}));
            this.detectors.add((Detector)new KeywordsDetector(0.3, PHPKeyword.getKeywordValues()));
            this.detectors.add((Detector)new ContainsDetector(0.95, new String[]{"++", "for(", "if(", "while(", "catch(", "switch(", "try{", "else{"}));
            this.detectors.add((Detector)new CamelCaseDetector(0.5));
        }

        public Set<Detector> getDetectors() {
            return this.detectors;
        }
    }
}

