/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.api.web.CodeColorizerFormat;
import org.sonar.colorizer.CDocTokenizer;
import org.sonar.colorizer.CppDocTokenizer;
import org.sonar.colorizer.InlineDocTokenizer;
import org.sonar.colorizer.KeywordsTokenizer;
import org.sonar.colorizer.StringTokenizer;
import org.sonar.colorizer.Tokenizer;
import org.sonar.php.api.PHPKeyword;

public class PhpSourceCodeColorizer
extends CodeColorizerFormat {
    private static final String[] PHP_RESERVED_VARIABLES_ARRAY = new String[]{"__FUNCTION__", "__CLASS__", "__METHOD__", "__NAMESPACE__", "__DIR__", "__FILE__", "__LINE__", "$this"};

    public PhpSourceCodeColorizer() {
        super("php");
    }

    public List<Tokenizer> getTokenizers() {
        HashSet keywords = Sets.newHashSet((Object[])PHP_RESERVED_VARIABLES_ARRAY);
        keywords.addAll(Sets.newHashSet((Object[])PHPKeyword.getKeywordValues()));
        String tagAfter = "</span>";
        ArrayList tokenizers = Lists.newArrayList();
        tokenizers.add(new CDocTokenizer("<span class=\"cd\">", tagAfter));
        tokenizers.add(new ShellCommentTokenizer("<span class=\"cd\">", tagAfter));
        tokenizers.add(new CppDocTokenizer("<span class=\"cppd\">", tagAfter));
        tokenizers.add(new KeywordsTokenizer("<span class=\"k\">", tagAfter, (Set)keywords));
        tokenizers.add(new StringTokenizer("<span class=\"s\">", tagAfter));
        return tokenizers;
    }

    private static class ShellCommentTokenizer
    extends InlineDocTokenizer {
        public ShellCommentTokenizer(String tagBefore, String tagAfter) {
            super("#", tagBefore, tagAfter);
        }
    }
}

